/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.emoji.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.SpannableString;
import android.text.style.ImageSpan;
import com.xdja.im.uikit.utils.ImageCache;
import com.xdja.im.uikit.utils.image.BitmapUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmotionUtils {
    private static Pattern pattern = Pattern.compile("(\\[emoji_[0-9]{3}\\])");

    public static SpannableString formatSmallSpanContent(CharSequence content, Context context) {
        return EmotionUtils.formatSpanContent(content, context, 0.8f);
    }

    public static SpannableString formatNormalSpanContent(CharSequence content, Context context) {
        return EmotionUtils.formatSpanContent(content, context, 1.0f);
    }

    public static SpannableString formatSpanContent(CharSequence content, Context context, float scale) {
        SpannableString spannableString = new SpannableString((CharSequence)"");
        try {
            spannableString = new SpannableString(content);
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                String emoStr = matcher.group(1);
                emoStr = emoStr.substring(1, emoStr.length() - 1);
                ImageCache imageCache = ImageCache.getInstance();
                Bitmap bitmap = null;
                if (scale == 0.8f) {
                    if (imageCache.smallCashGet(emoStr) != null) {
                        bitmap = imageCache.smallCashGet(emoStr);
                    } else {
                        bitmap = BitmapUtils.getBitmapWithName("sticker/emotion/" + emoStr + ".png", context.getResources());
                        bitmap = BitmapUtils.small(bitmap, scale);
                        imageCache.smallCashPut(emoStr, bitmap);
                    }
                } else if (scale == 1.0f) {
                    if (imageCache.get(emoStr) != null) {
                        bitmap = imageCache.get(emoStr);
                    } else {
                        bitmap = BitmapUtils.getBitmapWithName("sticker/emotion/" + emoStr + ".png", context.getResources());
                        bitmap = BitmapUtils.small(bitmap, scale);
                        imageCache.put(emoStr, bitmap);
                    }
                }
                ImageSpan span = new ImageSpan(context, bitmap);
                spannableString.setSpan((Object)span, matcher.start(), matcher.end(), 33);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return spannableString;
    }

    public static SpannableString formatSpanByIndex(Context context, int facesPos, float smallScall) {
        String srcName = "emoji_" + String.format("%03d", facesPos) + ".png";
        try {
            Bitmap bitmap = BitmapUtils.getBitmapWithName("sticker/emotion/" + srcName, context.getResources());
            bitmap = BitmapUtils.small(bitmap, smallScall);
            ImageSpan is = new ImageSpan(context, bitmap);
            String cs = "[emoji_" + String.format("%03d", facesPos) + "]";
            SpannableString ss = new SpannableString((CharSequence)cs);
            ss.setSpan((Object)is, 0, cs.length(), 33);
            return ss;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return new SpannableString((CharSequence)("[" + srcName + "]"));
    }

    public static boolean mathEmotion(String content) {
        Matcher matcher = pattern.matcher(content);
        return matcher.find();
    }
}

