/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.base;

import android.app.Dialog;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.ViewTreeObserver;
import com.xdja.im.base.di.component.DaggerUserComponent;
import com.xdja.im.base.di.component.RepositoryComponent;
import com.xdja.im.base.di.component.UserComponent;
import com.xdja.im.base.frame.Presenter;
import com.xdja.im.base.frame.presenter.BaseFragmentPresenter;
import com.xdja.im.base.frame.view.FragmentBaseView;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImBaseActivity;
import com.xdja.im.uikit.ui.dialog.CustomDialog;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.NetworkUtil;

public abstract class ImBaseFragment<P extends Presenter, V extends FragmentBaseView>
extends BaseFragmentPresenter<P, V> {
    protected UserComponent mComponent;

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        RepositoryComponent repositoryComponent = ImUiKit.getInstance().getComponent();
        if (repositoryComponent != null) {
            this.mComponent = DaggerUserComponent.builder().repositoryComponent(repositoryComponent).build();
        }
        if (this.mComponent == null) {
            LogUtil.e("Fatal :User component is null .");
            this.getActivity().finish();
        }
        this.getActivity().getWindow().getDecorView().getViewTreeObserver().addOnWindowFocusChangeListener(new ViewTreeObserver.OnWindowFocusChangeListener(){

            public void onWindowFocusChanged(boolean hasFocus) {
                ImBaseFragment.this.onActivityFocusChanged(hasFocus);
            }
        });
    }

    public void onDestroyView() {
        super.onDestroyView();
    }

    public void switchFragment(ImBaseFragment fragment, boolean addToBackStack) {
        this.switchFragment(fragment, 0x1020002, addToBackStack);
    }

    protected void switchFragment(ImBaseFragment fragment, @IdRes int contentRes, boolean addToBackStack) {
        FragmentManager fg = this.getFragmentManager();
        FragmentTransaction ft = fg.beginTransaction();
        if (addToBackStack) {
            ft.setCustomAnimations(R.anim.im_uikit_open_enter, R.anim.im_uikit_open_exit, R.anim.im_uikit_close_enter, R.anim.im_uikit_close_exit);
        }
        ft.replace(contentRes, (Fragment)fragment, fragment.getName());
        if (addToBackStack) {
            ft.addToBackStack(fragment.getName());
        }
        ft.commit();
    }

    protected void showMissingPermissionDialog() {
        new CustomDialog(this.getContext(), new CustomDialog.OnCloseListener(){

            @Override
            public void onClick(Dialog dialog, boolean confirm) {
                if (confirm) {
                    ImBaseFragment.this.startAppSettings();
                } else {
                    ImBaseFragment.this.finish();
                }
            }
        }).setDialogTitle(R.string.im_uikit_hint).setDialogContent(R.string.im_uikit_permission_hint).setPositiveButton(R.string.im_uikit_setting).setNegativeButton(R.string.im_uikit_btn_cancel).show();
    }

    private void startAppSettings() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + this.getPackageName())));
        this.startActivity(intent);
    }

    protected void checkNetType(final ImBaseActivity.OnNetCheckCallback result) {
        boolean isMobileConnected = NetworkUtil.isConnectByMobile(this.getContext());
        if (isMobileConnected) {
            new CustomDialog(this.getContext(), new CustomDialog.OnCloseListener(){

                @Override
                public void onClick(Dialog dialog, boolean confirm) {
                    result.onResult(!confirm);
                }
            }).setDialogTitle(result.getTitle()).setDialogContent(result.getContent()).setPositiveButton(result.getPositiveButton()).setNegativeButton(result.getNegativeButton()).show();
        } else {
            result.onResult(false);
        }
    }

    protected void finish() {
        this.getActivity().finish();
    }

    protected void onActivityFocusChanged(boolean hasFocus) {
    }

    protected void showToast(String content) {
        CommonTool.showToast(content);
    }

    protected void showToast(int resId) {
        CommonTool.showToast(resId);
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPackageName() {
        return this.getContext().getPackageName();
    }

    public abstract class OnNetCheckCallback {
        public abstract void onResult(boolean var1);

        protected String getContent() {
            return "";
        }

        protected String getTitle() {
            return ImBaseFragment.this.getString(R.string.im_uikit_hint);
        }

        protected String getPositiveButton() {
            return ImBaseFragment.this.getString(R.string.im_uikit_btn_continue);
        }

        protected String getNegativeButton() {
            return ImBaseFragment.this.getString(R.string.im_uikit_btn_cancel);
        }
    }
}

