/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.graphics.drawable.AnimationDrawable;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.VoiceFileInfo;
import com.xdja.im.core.model.screen.ScreenInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.ui.view.BaseSendItem;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.ScreenUtil;

public class ViewSendVoiceItem
extends BaseSendItem {
    private static final int MIN_DP = 80;
    private static final int FIRST_STEP_DP = 140;
    private static final int SECOND_STEP_DP = 180;
    private static final int MAX_DP = 200;
    private TextView mVoiceLength;
    private ImageView mVoiceAnimImg;
    private ScreenInfo mScreenInfo;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_send_voice;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mVoiceLength = (TextView)this.findViewById(R.id.tv_hint_time);
        this.mVoiceAnimImg = (ImageView)this.findViewById(R.id.img_anim_voice);
        this.mContentLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ChatListAdapterPresenter)ViewSendVoiceItem.this.getPresenter()).playVoice((TalkMessageBean)ViewSendVoiceItem.this.dataSource);
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        this.mScreenInfo = ScreenUtil.getScreenInfo(this.getActivity());
        this.initView();
    }

    private void initView() {
        VoiceFileInfo fileInfo = (VoiceFileInfo)((TalkMessageBean)this.dataSource).getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("file info is null error.");
            return;
        }
        int recordingTime = fileInfo.getAmountOfTime();
        this.setBackground(recordingTime);
        this.setVoiceLengthText(recordingTime);
        this.mVoiceAnimImg.setBackgroundResource(R.drawable.im_uikit_bg_voice_send_anim);
        if (((TalkMessageBean)this.dataSource).isBomb()) {
            this.mVoiceAnimImg.setBackgroundResource(R.drawable.im_uikit_bg_voice_send_white_anim);
        }
        if (((ChatListAdapterPresenter)this.getPresenter()).getVoiceMessageIsPlaying(fileInfo)) {
            this.startVoiceAnim();
        } else {
            this.stopVoiceAnim();
        }
    }

    private void setBackground(int recordingTime) {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mContentLayout.getLayoutParams();
        float bubbleLength = recordingTime <= 10 ? (float)(80 + 6 * recordingTime) * this.mScreenInfo.getDensity() : (recordingTime <= 20 ? (float)(140 + 4 * (recordingTime - 10)) * this.mScreenInfo.getDensity() : (recordingTime <= 30 ? (float)(180 + 2 * (recordingTime - 20)) * this.mScreenInfo.getDensity() : 200.0f * this.mScreenInfo.getDensity()));
        params.width = (int)bubbleLength;
        this.mContentLayout.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void setVoiceLengthText(int length) {
        this.mVoiceLength.setText((CharSequence)((length == 0 ? 1 : length) + "\""));
    }

    private void startVoiceAnim() {
        AnimationDrawable voiceAnim;
        if (this.mVoiceAnimImg != null && (voiceAnim = (AnimationDrawable)this.mVoiceAnimImg.getBackground()) != null && !voiceAnim.isRunning()) {
            voiceAnim.start();
        }
    }

    private void stopVoiceAnim() {
        AnimationDrawable voiceAnim;
        if (this.mVoiceAnimImg != null && (voiceAnim = (AnimationDrawable)this.mVoiceAnimImg.getBackground()) != null) {
            voiceAnim.stop();
            voiceAnim.selectDrawable(0);
        }
    }

    @Override
    protected void setTxtContentColor(int color2) {
        super.setTxtContentColor(color2);
        this.mVoiceLength.setTextColor(color2);
    }
}

