/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.manager;

import android.content.Context;
import android.text.TextUtils;
import com.xdja.imsdk.constant.ChangeAction;
import com.xdja.imsdk.constant.ImSdkFileConstant;
import com.xdja.imsdk.constant.internal.Constant;
import com.xdja.imsdk.db.DbHelper;
import com.xdja.imsdk.db.ImSdkDbUtils;
import com.xdja.imsdk.db.helper.OptHelper;
import com.xdja.imsdk.db.helper.OptType;
import com.xdja.imsdk.db.helper.UpdateArgs;
import com.xdja.imsdk.db.wrapper.MessageWrapper;
import com.xdja.imsdk.db.wrapper.SessionWrapper;
import com.xdja.imsdk.exception.ImSdkException;
import com.xdja.imsdk.http.HttpUtils;
import com.xdja.imsdk.http.bean.MsgBean;
import com.xdja.imsdk.logger.Logger;
import com.xdja.imsdk.manager.ImSdkCallbackManager;
import com.xdja.imsdk.manager.ImSdkConfigManager;
import com.xdja.imsdk.manager.ImSdkFileManager;
import com.xdja.imsdk.manager.ImSyncManager;
import com.xdja.imsdk.manager.ModelMapper;
import com.xdja.imsdk.manager.callback.BombCallback;
import com.xdja.imsdk.manager.callback.FileCallback;
import com.xdja.imsdk.manager.callback.NetCallback;
import com.xdja.imsdk.manager.callback.ResultCallback;
import com.xdja.imsdk.manager.callback.SendCallback;
import com.xdja.imsdk.manager.msg.ImSdkNetState;
import com.xdja.imsdk.manager.process.BombProcess;
import com.xdja.imsdk.manager.process.ReceiveProcess;
import com.xdja.imsdk.manager.process.SendOutProcess;
import com.xdja.imsdk.model.IMFileInfo;
import com.xdja.imsdk.model.IMMessage;
import com.xdja.imsdk.model.IMSession;
import com.xdja.imsdk.model.InitParam;
import com.xdja.imsdk.model.body.IMFileBody;
import com.xdja.imsdk.model.body.IMMessageBody;
import com.xdja.imsdk.model.internal.IMState;
import com.xdja.imsdk.util.FileUtils;
import com.xdja.imsdk.util.ToolUtils;
import com.xdja.pushsdk.PushClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ImSdkManager {
    private static ImSdkManager imSdkManager;
    private ImSdkNetState netState;
    private Context context;
    private String account;
    private String cardId;
    private SendOutProcess sendOutProcess;
    private ReceiveProcess receiveProcess;
    private BombProcess bombProcess;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImSdkManager getInstance() {
        Class<ImSdkManager> clazz = ImSdkManager.class;
        synchronized (ImSdkManager.class) {
            if (imSdkManager == null) {
                imSdkManager = Factory.getInstance();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return imSdkManager;
        }
    }

    public void init(Context context, InitParam initParam) {
        this.context = context;
        this.account = initParam.getAccount();
        this.cardId = initParam.getTfcardId();
        this.initImSdkDatabase(context);
        this.initConfig(this.account, this.cardId, initParam.getProperties());
        ModelMapper.getIns().init(this.account);
        this.netState = new ImSdkNetState();
        this.sendOutProcess = new SendOutProcess();
        this.receiveProcess = new ReceiveProcess(this.account, new SendOut());
        this.bombProcess = new BombProcess(new BombDestroyed());
        HttpUtils.getInstance().init(context);
        ImSyncManager.getInstance().init(this.account, this.cardId, initParam.getTicket(), new ResultProcess(), new NetWork());
        ImSdkFileManager.getInstance().init(new FileText(), new NetWork());
        this.subscribePushSdk();
        this.resetAllAnomalousMsg();
        ImSdkCallbackManager.getInstance().callState(50010);
        Logger.getLogger().d("ImSdk init done ...");
    }

    public int syncMessage() {
        Logger.getLogger().d("ImSdk current state [" + this.netState + "]");
        if (this.netState != null && !this.netState.disConnected()) {
            return -3;
        }
        ImSyncManager.getInstance().syncMessage();
        return 0;
    }

    public int releaseAll() {
        this.releaseImAndPushSdk();
        HttpUtils.getInstance().cancelAll();
        ImSyncManager.getInstance().cancelAll();
        ImSdkCallbackManager.getInstance().cancelAllCallback();
        ImSdkConfigManager.getInstance().releaseAll();
        DbHelper.getInstance().close();
        Logger.getLogger().i("ImSdk release done ...");
        return 0;
    }

    public int saveConfig(Map<String, String> param) {
        return ImSdkConfigManager.getInstance().saveConfig(param);
    }

    public String getConfigByKey(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        return ImSdkConfigManager.getInstance().getConfigByKey(key);
    }

    public List<IMSession> getIMSessionList(String begin, int size) {
        List<SessionWrapper> wrappers = ImSdkDbUtils.querySessions(begin, size);
        return ModelMapper.getIns().mapSessions(wrappers);
    }

    public List<IMMessage> getIMMessageList(String tag, long begin, int size) {
        List<MessageWrapper> wrappers = ImSdkDbUtils.queryMessages(OptHelper.getIns().getMQuery(tag, begin, size), OptType.MQuery.SHOW);
        return ModelMapper.getIns().mapMessages(wrappers);
    }

    public List<IMMessage> getImageList(String tag, int begin, int size) {
        List<MessageWrapper> wrappers = ImSdkDbUtils.queryMessages(OptHelper.getIns().getIQuery(tag, begin, size), OptType.MQuery.ALL);
        return ModelMapper.getIns().mapMessages(wrappers);
    }

    public List<IMMessage> getFileList(String tag) {
        List<MessageWrapper> wrappers = TextUtils.isEmpty((CharSequence)tag) ? ImSdkDbUtils.queryMessages(OptHelper.getIns().getFQuery(), OptType.MQuery.RAW) : ImSdkDbUtils.queryMessages(OptHelper.getIns().getFQuery(tag), OptType.MQuery.RAW);
        return ModelMapper.getIns().mapMessages(wrappers);
    }

    public List<IMMessage> getFileList(String sessionTag, ImSdkFileConstant.FileGetType getType, int begin, int size) {
        String sql = null;
        OptType.MQuery type = OptType.MQuery.ALL;
        switch (getType) {
            case EXIST_ALL: {
                sql = OptHelper.getIns().getFQuery();
                type = OptType.MQuery.RAW;
                break;
            }
            case CUR_EXIST_MEDIA: {
                sql = OptHelper.getIns().getCMQuery(sessionTag);
                type = OptType.MQuery.ALL;
                break;
            }
            case CUR_ALL_MEDIA: {
                sql = OptHelper.getIns().getCAQuery(sessionTag);
                type = OptType.MQuery.ALL;
                break;
            }
            case CUR_ALL: {
                sql = OptHelper.getIns().getCAllQuery(sessionTag);
                break;
            }
            case OTHER: {
                sql = OptHelper.getIns().getOtherQuery(sessionTag);
                type = OptType.MQuery.ALL;
            }
        }
        List<MessageWrapper> wrappers = ImSdkDbUtils.queryMessages(sql, type);
        return ModelMapper.getIns().mapMessages(wrappers);
    }

    public IMMessage getIMMessageById(long id) {
        MessageWrapper wrapper = ImSdkDbUtils.queryMessage(OptHelper.getIns().getAMQuery(id), OptType.MQuery.ALL);
        return ModelMapper.getIns().mapMessage(wrapper);
    }

    public int getRemindIMMessageCount(String tag) {
        return ImSdkDbUtils.queryRemindCount(OptHelper.getIns().getRQuery(tag));
    }

    public int getAllRemindIMMessageCount() {
        return ImSdkDbUtils.queryRemindCount(OptHelper.getIns().getRQuery(""));
    }

    public int setRemind(String tag, int type) {
        int remind = type == 0 ? 0 : 1;
        return ImSdkDbUtils.update(OptHelper.getIns().getRUpdate(tag, remind));
    }

    public int clearIMSessionAllIMMessage(String tag) {
        this.cancelSending(tag);
        this.processSReadBomb(tag);
        int result = ImSdkDbUtils.delete(OptHelper.getIns().getMSDel(tag));
        this.callbackS(tag);
        return result;
    }

    public int clearAllLocalData() {
        this.cancelSending();
        this.removeAllBomb();
        this.processAllReadBomb();
        ImSdkDbUtils.delete(OptHelper.getIns().getSADel());
        return 0;
    }

    public int clearCache() {
        FileUtils.deleteFile(ImSdkDbUtils.queryPaths(OptHelper.getIns().getCachePathQuery()));
        return 0;
    }

    public long getCacheSize() {
        Logger.getLogger().d("ImSdk getCache start... ");
        return FileUtils.getCacheSize(ImSdkDbUtils.queryPaths(OptHelper.getIns().getCachePathQuery()));
    }

    public int deleteIMSession(List<String> tags) {
        this.cancelSending(tags);
        this.processSReadBomb(tags);
        ImSdkDbUtils.delete(OptHelper.getIns().getSDel(tags));
        return 0;
    }

    public int deleteIMMessage(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return -1;
        }
        SessionWrapper wrapper = ImSdkDbUtils.querySession(OptHelper.getIns().getSMIQuery(ids.get(0)), OptType.SQuery.NON);
        if (wrapper == null || wrapper.getSessionEntryDb() == null) {
            return -1;
        }
        this.cancelSendingRequest(ids);
        this.processMReadBomb(ids);
        int result = ImSdkDbUtils.delete(OptHelper.getIns().getMDel(ids));
        if (result != 0) {
            return result;
        }
        this.changeSession(ids, wrapper);
        return result;
    }

    public IMSession addCustomSession(IMSession session) {
        String tag = ToolUtils.getSessionTag(session.getImPartner(), session.getSessionType());
        SessionWrapper custom = ImSdkDbUtils.querySession(OptHelper.getIns().getSMQuery(tag), OptType.SQuery.HAVE);
        if (custom != null && custom.getSessionEntryDb() != null && custom.getSessionEntryDb().getId() > 0L) {
            return ModelMapper.getIns().mapSession(custom);
        }
        SessionWrapper wrapper = ModelMapper.getIns().getSWrapper(session);
        long id = ImSdkDbUtils.saveSession(wrapper);
        wrapper.getSessionEntryDb().setId(id);
        return ModelMapper.getIns().mapSession(wrapper);
    }

    public IMMessage addCustomMessage(String tag, IMMessage message) throws ImSdkException {
        return ModelMapper.getIns().mapMessage(this.saveIMMessage(tag, message, true));
    }

    public IMMessage sendIMMessage(IMMessage message) throws ImSdkException {
        if (this.sendOutProcess == null) {
            throw new ImSdkException(-2);
        }
        message.setState(0);
        String tag = ToolUtils.getSessionTag("", message);
        MessageWrapper wrapper = this.saveIMMessage(tag, message, false);
        IMMessage result = ModelMapper.getIns().mapMessageNoDecrypt(wrapper);
        this.sendOutProcess.add(wrapper);
        return result;
    }

    public int recallIMMessage(long id, int action) {
        MessageWrapper wrapper = ImSdkDbUtils.queryMessage(OptHelper.getIns().getMIQuery(id), OptType.MQuery.NO);
        if (wrapper.getMsgEntryDb() == null || !wrapper.getMsgEntryDb().isSent() || wrapper.getMsgEntryDb().getState() < 1 || wrapper.getMsgEntryDb().isRecalled()) {
            return -103;
        }
        if (action == 1) {
            this.cancelRecall(id);
            return 0;
        }
        if (action == 0) {
            long distance = ImSdkConfigManager.getInstance().getCurrentMillis() - wrapper.getMsgEntryDb().getSent_time();
            if (distance > 120000L) {
                return -104;
            }
            if (this.sendOutProcess != null) {
                wrapper.getMsgEntryDb().setState(5);
                this.sendOutProcess.recall(wrapper);
                return 0;
            }
        }
        return -3;
    }

    public int resendIMMessage(long id) {
        if (this.sendOutProcess == null) {
            return -2;
        }
        MessageWrapper wrapper = ImSdkDbUtils.queryMessage(OptHelper.getIns().getAMQuery(id), OptType.MQuery.ALL);
        Logger.getLogger().d("ImSdk resend message " + wrapper);
        if (wrapper == null || wrapper.getMsgEntryDb() == null) {
            return -1;
        }
        this.sendOutProcess.add(wrapper);
        return -1;
    }

    public int changeMessageState(IMMessage message, int state) {
        MessageWrapper msg = ImSdkDbUtils.queryMessage(OptHelper.getIns().getMIQuery(message.getIMMessageId()), OptType.MQuery.NO);
        if (msg == null || msg.getMsgEntryDb() == null) {
            return -1;
        }
        if (msg.getMsgEntryDb().isRecalled()) {
            return -1;
        }
        msg.getMsgEntryDb().setState(state);
        message.setState(state);
        this.updateAndSave(msg, message);
        this.addBombQueue(message);
        IMMessage callbackMsg = this.getIMMessageById(message.getIMMessageId());
        this.callbackSM(callbackMsg, msg.getMsgEntryDb().getSession_flag());
        this.sendStates();
        return 0;
    }

    public int processFile(IMFileInfo fileInfo, Constant.FileOptType type) {
        if (this.sendOutProcess == null || this.receiveProcess == null) {
            return -2;
        }
        ImSdkFileManager.getInstance().filePauseResume(fileInfo, type);
        return 0;
    }

    public int receiveFileStart(List<IMFileInfo> files) {
        if (this.sendOutProcess == null) {
            return -2;
        }
        ImSdkFileManager.getInstance().downloadStart(files);
        return 0;
    }

    private void cancelSending() {
        List<Long> sendingIds = ImSdkDbUtils.queryIds(OptHelper.getIns().getIngQuery(this.account, ""));
        this.cancelSendingRequest(sendingIds);
    }

    private void cancelSending(String tag) {
        ArrayList<String> tags = new ArrayList<String>();
        tags.add(tag);
        this.cancelSending(tags);
    }

    private void cancelSending(List<String> tags) {
        List<Long> sendingIds = ImSdkDbUtils.queryIds(OptHelper.getIns().getIngQuery(this.account, tags));
        this.cancelSendingRequest(sendingIds);
    }

    private void cancelSendingRequest(List<Long> ids) {
        if (ids != null && !ids.isEmpty()) {
            HttpUtils.getInstance().cancelRequest(ids);
        }
    }

    private void cancelRecall(long id) {
        HttpUtils.getInstance().cancelRequest(id);
    }

    private void processAllReadBomb() {
        List<MessageWrapper> wrappers = ImSdkDbUtils.queryMessages(OptHelper.getIns().getARBQuery(this.account, ""), OptType.MQuery.SHOW);
        this.destroyAndSend(wrappers);
    }

    private void processSReadBomb(String tag) {
        List<MessageWrapper> wrappers = ImSdkDbUtils.queryMessages(OptHelper.getIns().getARBQuery(this.account, tag), OptType.MQuery.SHOW);
        this.removeBomb(ModelMapper.getIns().getIds(wrappers));
        this.destroyAndSend(wrappers);
    }

    private void processSReadBomb(List<String> tags) {
        List<MessageWrapper> wrappers = ImSdkDbUtils.queryMessages(OptHelper.getIns().getARBQuery(this.account, tags), OptType.MQuery.SHOW);
        this.removeBomb(ModelMapper.getIns().getIds(wrappers));
        this.destroyAndSend(wrappers);
    }

    private void processMReadBomb(List<Long> ids) {
        List<MessageWrapper> wrappers = ImSdkDbUtils.queryMessages(OptHelper.getIns().getMRBQuery(this.account, ids), OptType.MQuery.SHOW);
        this.removeBomb(ModelMapper.getIns().getIds(wrappers));
        this.destroyAndSend(wrappers);
    }

    private void destroyAndSend(List<MessageWrapper> wrappers) {
        if (wrappers == null || wrappers.size() == 0) {
            return;
        }
        this.updateAndSave(wrappers);
        this.sendStates();
    }

    private void changeSession(List<Long> msgIds, SessionWrapper wrapper) {
        if (wrapper.getSessionEntryDb() == null || wrapper.getSessionEntryDb().getLast_msg() == null) {
            return;
        }
        if (msgIds.contains(wrapper.getSessionEntryDb().getLast_msg())) {
            String tag = wrapper.getSessionEntryDb().getSession_flag();
            MessageWrapper msg = ImSdkDbUtils.queryMessage(OptHelper.getIns().getMQuery(tag), OptType.MQuery.NO);
            if (msg != null && msg.getMsgEntryDb() != null) {
                ImSdkDbUtils.update(OptHelper.getIns().getLUpdate(tag, msg.getMsgEntryDb().getId(), msg.getMsgEntryDb().getSort_time()));
            }
            this.callbackS(tag);
        }
    }

    private void addBombQueue(IMMessage message) {
        if (message.isReadBomb()) {
            IMFileBody fileBody;
            IMMessageBody body;
            if (message.isTextIMMessage()) {
                this.bombProcess.add(message);
            }
            if (message.isFileIMMessage() && (body = message.getMessageBody()) != null && body instanceof IMFileBody && (fileBody = (IMFileBody)body).isImage()) {
                this.bombProcess.add(message);
            }
        }
    }

    private void removeBomb(List<Long> list) {
        this.bombProcess.remove(list);
    }

    private void removeAllBomb() {
        this.bombProcess.removeAll();
    }

    private MessageWrapper saveIMMessage(String tag, IMMessage message, boolean isCall) throws ImSdkException {
        tag = ToolUtils.getSessionTag(tag, message);
        SessionWrapper sWrapper = ImSdkDbUtils.querySession(OptHelper.getIns().getSQuery(tag), OptType.SQuery.NON);
        boolean newSession = false;
        if (sWrapper == null) {
            sWrapper = ModelMapper.getIns().getSWrapper(tag, message);
            ImSdkDbUtils.saveSession(sWrapper);
            newSession = true;
        }
        message.setCardId(this.cardId);
        MessageWrapper mWrapper = ModelMapper.getIns().getMWrapper(tag, message);
        long id = ImSdkDbUtils.saveMessage(mWrapper);
        if (id < 0L) {
            throw new ImSdkException(-5);
        }
        if (mWrapper.getMsgEntryDb() != null) {
            mWrapper.getMsgEntryDb().setId(id);
            IMSession session = this.callbackS(tag, newSession);
            if (isCall) {
                this.callbackM(id, session);
            }
        }
        if (mWrapper.getFileMsgDb() != null) {
            mWrapper.getFileMsgDb().setEncrypt_path(mWrapper.getFileMsgDb().getFile_path());
        }
        return mWrapper;
    }

    private void updateAndSave(MessageWrapper wrapper, IMMessage message) {
        UpdateArgs update = message.isBomb() ? OptHelper.getIns().getBombsUpdate(ModelMapper.getIns().mapBodyType(message), message.getIMMessageId()) : OptHelper.getIns().getMCUpdate(message.getIMMessageId(), message.getState());
        ArrayList<MessageWrapper> wrappers = new ArrayList<MessageWrapper>();
        wrappers.add(wrapper);
        List<IMState> states = ModelMapper.getIns().getStates(wrappers);
        if (!states.isEmpty()) {
            ImSdkDbUtils.updateAndSave(update, states.get(0));
        } else {
            ImSdkDbUtils.update(update);
        }
    }

    private void updateAndSave(List<MessageWrapper> wrappers) {
        ArrayList<UpdateArgs> bombs = new ArrayList<UpdateArgs>();
        for (MessageWrapper wrapper : wrappers) {
            if (wrapper.getMsgEntryDb() == null) continue;
            UpdateArgs bomb = OptHelper.getIns().getBombsUpdate(ModelMapper.getIns().mapBodyType(wrapper), wrapper.getMsgEntryDb().getId());
            bombs.add(bomb);
            wrapper.getMsgEntryDb().setState(4);
        }
        List<IMState> states = ModelMapper.getIns().getStates(wrappers);
        ImSdkDbUtils.updateAndSaveBatch(bombs, states);
    }

    private void sendStates() {
        if (this.sendOutProcess == null) {
            return;
        }
        List<IMState> states = ModelMapper.getIns().mapStates(ImSdkDbUtils.queryStates());
        this.sendOutProcess.add(states);
    }

    private void removeState(long id) {
        if (this.sendOutProcess == null) {
            return;
        }
        this.sendOutProcess.removeState(id);
    }

    private void callbackS(String tag) {
        SessionWrapper wrapper = ImSdkDbUtils.querySession(OptHelper.getIns().getSMQuery(tag), OptType.SQuery.HAVE);
        IMSession session = ModelMapper.getIns().mapSession(wrapper);
        if (session == null) {
            return;
        }
        ImSdkCallbackManager.getInstance().callSession(session, ChangeAction.ACT_RF);
    }

    private IMSession callbackS(String tag, boolean isNew) {
        SessionWrapper wrapper = ImSdkDbUtils.querySession(OptHelper.getIns().getSMQuery(tag), OptType.SQuery.HAVE);
        IMSession session = ModelMapper.getIns().mapSession(wrapper);
        if (isNew) {
            ImSdkCallbackManager.getInstance().callSession(session, ChangeAction.ACT_ADD);
        } else {
            ImSdkCallbackManager.getInstance().callSession(session, ChangeAction.ACT_RF);
        }
        return session;
    }

    private void callbackM(long id, IMSession session) {
        if (session == null) {
            return;
        }
        MessageWrapper wrapper = ImSdkDbUtils.queryMessage(OptHelper.getIns().getAMQuery(id), OptType.MQuery.SHOW);
        IMMessage message = ModelMapper.getIns().mapMessage(wrapper);
        if (message == null) {
            return;
        }
        ArrayList<IMMessage> messages = new ArrayList<IMMessage>();
        messages.add(message);
        ImSdkCallbackManager.getInstance().callMessage(session, messages, ChangeAction.ACT_ADD);
    }

    private void callbackSM(IMMessage message, String tag) {
        if (message.isBomb() || message.isRead()) {
            SessionWrapper wrapper = ImSdkDbUtils.querySession(OptHelper.getIns().getSMQuery(tag), OptType.SQuery.HAVE);
            IMSession session = ModelMapper.getIns().mapSession(wrapper);
            if (session == null) {
                return;
            }
            ImSdkCallbackManager.getInstance().callChange(session, message);
            ImSdkCallbackManager.getInstance().callSession(session, ChangeAction.ACT_RF);
        }
    }

    private void initImSdkDatabase(Context context) {
        try {
            DbHelper.getInstance().initDatabase(context, this.account);
        }
        catch (Exception e) {
            Logger.getLogger().e("Database init error!!");
        }
    }

    private void initConfig(String account, String cardId, Map<String, String> property) {
        ImSdkConfigManager.getInstance().init(account, cardId, property);
    }

    private void subscribePushSdk() {
        PushClient.init((Context)this.context, (String)ImSdkConfigManager.getInstance().getPushClientId());
        PushClient.subTopic((Context)this.context, (String)ImSdkConfigManager.getInstance().getPushTopic(), (int)0);
    }

    private void pingPushSdk() {
        PushClient.checkPushOnline((Context)this.context);
    }

    private void resetAllAnomalousMsg() {
        ImSdkDbUtils.update(OptHelper.getIns().getAAUpdate(0, -3));
        ImSdkDbUtils.update(OptHelper.getIns().getAAUpdate(-4, -5));
        ImSdkDbUtils.update(OptHelper.getIns().getFAUpdate(16, 17));
        ImSdkDbUtils.update(OptHelper.getIns().getFAUpdate(22, 23));
        ImSdkDbUtils.update(OptHelper.getIns().getHAUpdate(16, 17));
        ImSdkDbUtils.update(OptHelper.getIns().getHAUpdate(22, 23));
        ImSdkDbUtils.update(OptHelper.getIns().getRAUpdate(16, 17));
        ImSdkDbUtils.update(OptHelper.getIns().getRAUpdate(22, 23));
        this.processAllReadBomb();
    }

    private void releaseImAndPushSdk() {
        if (this.receiveProcess != null) {
            this.receiveProcess.stop();
        }
        if (this.sendOutProcess != null) {
            this.sendOutProcess.stop();
        }
        if (this.bombProcess != null) {
            this.bombProcess.stop();
        }
        PushClient.unsubscribe((Context)this.context, (String)ImSdkConfigManager.getInstance().getPushTopic(), (String)"");
    }

    private void networkReport(int state) {
        if (this.netState == null) {
            Logger.getLogger().d("ImSdk have not ready...");
            return;
        }
        Logger.getLogger().d("ImSdk net state is OK " + state + ", " + this.netState);
        if (this.processNetState(state)) {
            ImSdkCallbackManager.getInstance().callNetwork(this.netState.getNetState());
        } else if (state == 10000 || state == 10002 || state == 40000) {
            ImSdkCallbackManager.getInstance().callNetwork(this.netState.getNetState());
        }
    }

    private boolean processNetState(int state) {
        if (this.netState == null) {
            return false;
        }
        if (state == 10000) {
            return this.netState.change(0);
        }
        if (state == 10001) {
            return this.netState.change(2);
        }
        if (state == 10002) {
            return this.netState.change(0);
        }
        if (state == 10003) {
            return this.netState.change(2);
        }
        if (state == 10004) {
            return this.netState.change(1);
        }
        if (state == 40000) {
            this.pingPushSdk();
            return this.netState.change(0);
        }
        if (state == 40004) {
            return this.netState.change(2);
        }
        if (state == 40007) {
            return this.netState.change(1);
        }
        return false;
    }

    class BombDestroyed
    implements BombCallback {
        BombDestroyed() {
        }

        @Override
        public void BombDestroy(IMMessage message) {
            ImSdkManager.this.changeMessageState(message, 4);
        }
    }

    private static class Factory {
        private Factory() {
        }

        static ImSdkManager getInstance() {
            return new ImSdkManager();
        }
    }

    class FileText
    implements FileCallback {
        FileText() {
        }

        @Override
        public void SendFileText(long id) {
            MessageWrapper message = ImSdkDbUtils.queryMessage(OptHelper.getIns().getAMQuery(id), OptType.MQuery.ALL);
            ImSdkManager.this.sendOutProcess.sendFileText(message);
        }

        @Override
        public void DecryptFile(MessageWrapper message, ImSdkFileConstant.FileType type) {
            ImSdkManager.this.receiveProcess.add(message, type);
        }
    }

    class NetWork
    implements NetCallback {
        NetWork() {
        }

        @Override
        public void NetChanged(int state) {
            ImSdkManager.this.networkReport(state);
        }
    }

    class ResultProcess
    implements ResultCallback {
        ResultProcess() {
        }

        @Override
        public void ReceiveMessage(List<MsgBean> msgList) {
            ImSdkManager.this.receiveProcess.add(msgList);
        }

        @Override
        public void SendState() {
            ImSdkManager.this.sendStates();
        }

        @Override
        public void RemoveState(long id) {
            ImSdkManager.this.removeState(id);
        }
    }

    class SendOut
    implements SendCallback {
        SendOut() {
        }

        @Override
        public void SendStates() {
            ImSdkManager.this.sendStates();
        }
    }
}

