package com.xdja.im.base.di.module;

import android.content.Context;

import com.xdja.im.base.di.DiConfig;
import com.xdja.im.base.di.scope.Scoped;
import com.xdja.im.base.di.scope.UserScope;
import com.xdja.im.core.repository.impl.datasource.CloudDataStoreImpl;
import com.xdja.im.core.repository.impl.datasource.DiskDataStoreImpl;
import com.xdja.im.core.repository.impl.datasource.MemoryDataStoreImpl;
import com.xdja.im.core.repository.interf.datasource.CloudDataStore;
import com.xdja.im.core.repository.interf.datasource.DiskDataStore;
import com.xdja.im.core.repository.interf.datasource.MemoryDataStore;
import com.xdja.imsdk.ImClient;

import dagger.Module;
import dagger.Provides;

/**
 * @Package: com.xdja.im.base.di.module
 * @Author: xdjaxa
 * @Creation: 2017-04-11 16:17
 * @Version V1.0
 * @Description:
 */
@Module
public class DataStoreModule {

    @UserScope
    @Provides
    CloudDataStore provideCloudDataStore(CloudDataStoreImpl cloudDataStore) {
        return cloudDataStore;
    }

    @UserScope
    @Provides
    DiskDataStore provideDiskDataStore(DiskDataStoreImpl diskDataStore) {
        return diskDataStore;
    }

    @UserScope
    @Provides
    MemoryDataStore provideMemoryDataStore(MemoryDataStoreImpl memoryDataStore) {
        return memoryDataStore;
    }

    @UserScope
    @Provides
    ImClient provideImClient(@Scoped(DiConfig.CONTEXT_SCOPE_APP) Context context) {
        return ImClient.getInstance(context);
    }
}
