package com.xdja.im.common.cache.impl;

import com.xdja.im.common.cache.interf.PropertyCache;
import com.xdja.im.common.persistent.PropertyUtil;

import java.util.HashMap;
import java.util.Map;

import javax.inject.Inject;

/**
 * @Package: com.xdja.im.common.cache.impl
 * @Author: xdjaxa
 * @Creation: 2017-04-13 11:41
 * @Version V1.0
 * @Description:
 */
public class PropertyCacheImpl implements PropertyCache {


    public static final String PROPERTY_PN_SERVER = "pn.ipport.properties";

    private PropertyUtil propertyUtil;

    private Map<String, String> propertyEntity;

    @Inject
    public PropertyCacheImpl(PropertyUtil propertyUtil) {
        this.propertyUtil = propertyUtil;
    }

    @Override
    public Map<String, String> get() {
        if (this.propertyEntity == null) {
            propertyEntity = new HashMap<>();
            propertyUtil.load(PROPERTY_PN_SERVER);
            this.propertyEntity = this.propertyUtil.getAll();
        }
        return propertyEntity;
    }
}
