package com.xdja.im.common.cache.impl;

import android.text.TextUtils;

import com.xdja.im.common.cache.entity.UserEntity;
import com.xdja.im.common.cache.interf.UserCache;

import javax.inject.Inject;

/**
 * @Package: com.xdja.im.common.cache.impl
 * @Author: xdjaxa
 * @Creation: 2017-05-04 15:52
 * @Version V1.0
 * @Description:
 */
public class UserCacheImpl implements UserCache {

    private UserEntity userEntity;

    @Inject
    public UserCacheImpl() {
    }

    @Override
    public void put(UserEntity userEntity) {
        this.userEntity = userEntity;
    }

    @Override
    public UserEntity get() {
        return userEntity;
    }

    @Override
    public boolean isMine(String account) {
        if (TextUtils.isEmpty(account)) {
            return false;
        }
        if (userEntity == null) {
            return false;
        }
        return account.equals(userEntity.getAccount());
    }
}
