package com.xdja.im.common.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import com.xdja.im.common.database.builder.SessionEntityBuilder;
import com.xdja.im.common.database.builder.SettingEntityBuilder;

/**
 * @Package: com.xdja.im.common.database
 * @Author: xdjaxa
 * @Creation: 2017-05-22 10:54
 * @Version V1.0
 * @Description:
 */
public class DatabaseHelper extends SQLiteOpenHelper {

    private Context dbContext;

    public DatabaseHelper(DBContext context, String name,
                          SQLiteDatabase.CursorFactory factory,
                          int version) {
        super(context, name, factory, version);
        this.dbContext = context;
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        createSettingTable(db);
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {

    }

    /**
     * 会话设置相关信息
     *
     * @param db
     */
    private void createSettingTable(SQLiteDatabase db) {
        db.execSQL(SettingEntityBuilder.SQL_CREATE_TABLE_SETTING_ENTRY);
        db.execSQL(SessionEntityBuilder.SQL_CREATE_TABLE_SESSION_ENTRY);
    }
}
