package com.xdja.im.lib.camera.utils;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.hardware.Camera;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.support.v4.content.FileProvider;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

/**
 * @Package: com.xdja.im.lib.camera.utils
 * @Author: xdjaxa
 * @Creation: 2017-04-26 10:16
 * @Version V1.0
 * @Description:
 */
public class CameraHelper {

    /**
     * 相机拍照照片目录
     */
    public static final String PATH_DCIM = "/DCIM/camera/";


    private static File mTakePhotoFile;

    /**
     * Id of the camera to access. 0 is the first camera.
     */
    private static final int CAMERA_ID = 0;

    /**
     * 拍照
     *
     * @param activity
     * @param requestCode
     */
    public static void takePhoto(Activity activity, int requestCode) {
        Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        intent.putExtra(MediaStore.Images.Media.ORIENTATION, 0);
        intent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
        if (intent.resolveActivity(activity.getPackageManager()) != null) {

            mTakePhotoFile = createFile("IMG_", ".jpg");
            if (mTakePhotoFile == null) {
                return;
            }
            // 默认情况下，即不需要指定intent.putExtra(MediaStore.EXTRA_OUTPUT, uri);
            // 照相机有自己默认的存储路径，拍摄的照片将返回一个缩略图。如果想访问原始图片，
            // 可以通过dat extra能够得到原始图片位置。即，如果指定了目标uri，data就没有数据，
            // 如果没有指定uri，则data就返回有数据！

            Uri uri;
            if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
                uri = Uri.fromFile(mTakePhotoFile);
            } else {
                File imageRootPath;
                if (ToolUtils.isSdCardExist()) {
                    //文件保存路径
                    imageRootPath =  Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_PICTURES);
                } else {
                    imageRootPath = Environment.getDataDirectory();
                }
                File mediaStorageDir = new File(imageRootPath, PATH_DCIM);
                if (!mediaStorageDir.exists()) {
                    mediaStorageDir.mkdirs();
                }
                String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
                mTakePhotoFile = new File(mediaStorageDir.getPath() + File.separator + "IMG_" + timeStamp + ".jpg");
                try {
                    if (mTakePhotoFile.exists()) {
                        mTakePhotoFile.delete();
                    }
                    mTakePhotoFile.createNewFile();
                } catch (Exception e) {
                    e.printStackTrace();
                }
                uri = FileProvider.getUriForFile(activity, ProviderUtil.getFileProviderName(activity), mTakePhotoFile);
                //并且这样可以解决MIUI系统上拍照返回size为0的情况
                //uri = FileProvider.getUriForFile(activity, ProviderUtil.getFileProviderName(activity), mTakePhotoFile);
                //加入uri权限 要不三星手机不能拍照
                List<ResolveInfo> resInfoList = activity.getPackageManager().queryIntentActivities
                        (intent, PackageManager.MATCH_DEFAULT_ONLY);
                for (ResolveInfo resolveInfo : resInfoList) {
                    String packageName = resolveInfo.activityInfo.packageName;
                    activity.grantUriPermission(packageName, uri, Intent
                            .FLAG_GRANT_WRITE_URI_PERMISSION | Intent.FLAG_GRANT_READ_URI_PERMISSION);
                }
            }
            intent.putExtra(MediaStore.EXTRA_OUTPUT, uri);
        }
        activity.startActivityForResult(intent, requestCode);
    }

    /**
     * 根据系统时间、前缀、后缀产生一个文件
     */
    public static File createFile(String prefix, String suffix) {
        String imageRootPath;
        if (ToolUtils.isSdCardExist()) {
            //文件保存路径
            imageRootPath = Environment.getExternalStorageDirectory() + PATH_DCIM;
        } else {
            imageRootPath = Environment.getDataDirectory().getAbsolutePath() + PATH_DCIM;
        }

        File imgRootPath = new File(imageRootPath);
        if (!imgRootPath.exists()) {
            imgRootPath.mkdirs();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.CHINA);
        String filename = prefix + dateFormat.format(new Date(System.currentTimeMillis())) + suffix;
        //文件名称
        String photoFileCachePath = imageRootPath + filename;
        return new File(photoFileCachePath);
    }

    /**
     * 扫描图片
     *
     * @param activity
     * @param file
     */
    public static void galleryAddPic(Activity activity, File file) {
        Intent mediaScanIntent = new Intent(Intent.ACTION_MEDIA_SCANNER_SCAN_FILE);
        Uri contentUri = Uri.fromFile(file);
        mediaScanIntent.setData(contentUri);
        activity.sendBroadcast(mediaScanIntent);
    }

    public static File getTakePhotoFile() {
        return mTakePhotoFile;
    }

    /**
     * A safe way to get an instance of the Camera object
     *
     * @param cameraId
     * @return
     */
    public static Camera getCameraInstance(int cameraId) {
        Camera c = null;
        try {
            c = Camera.open(cameraId); // attempt to get a Camera instance
        } catch (Exception e) {
            e.printStackTrace();
        }
        return c; // returns null if camera is unavailable
    }

    /**
     * release the camera for other applications
     */
    private void releaseCamera(Camera camera) {
        if (camera != null) {
            camera.release();
            camera = null;
        }
    }
}
