package com.xdja.im.lib.filemanage.presenter;

import android.os.Bundle;

import com.xdja.im.base.di.component.DaggerUserComponent;
import com.xdja.im.base.di.component.RepositoryComponent;
import com.xdja.im.base.di.component.UserComponent;
import com.xdja.im.lib.filemanage.commend.Command;
import com.xdja.im.lib.filemanage.commend.RemindNewMessage;
import com.xdja.im.lib.filemanage.error.OkException;
import com.xdja.im.lib.filemanage.error.OkHandler;
import com.xdja.im.lib.filemanage.view.FragmentVu;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.notification.NotificationUtil;
import com.xdja.im.uikit.utils.log.LogUtil;


/**
 * Created by jing on 2015/11/13.
 */
public abstract class IMFragmentPresenter<P extends Command, V extends FragmentVu>
        extends BasePresenterFragment<P, V> {

    protected UserComponent useCaseComponent;

    protected RemindNewMessage remindNewMessage;

    protected OkHandler<OkException> okHandler;

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        RepositoryComponent repositoryComponent = ImUiKit.getInstance().getComponent();
        if (repositoryComponent != null) {
            useCaseComponent = DaggerUserComponent.builder()
                    .repositoryComponent(repositoryComponent)
                    .build();
        }
        if (useCaseComponent == null) {
            LogUtil.e("Fatal :User component is null .");
            getActivity().finish();
        }
//        if (null == IMAccountLifeCycle.imAccountLifeCycle || null == IMAccountLifeCycle.imAccountLifeCycle.getComponent()) {
//            //容错处理，回退到登陆界面
//            LogUtil.d("","未查询到用户信息注入提供对象");
//            Intent intent = Intent.makeMainActivity(
//                    new ComponentName(getContext().getPackageName(), "com.xdja.presenter_mainframe.presenter.activity.LauncherPresenter"));//modify by xnn for inter version @20170224
//            intent.putExtra("exit", true);
//            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
//            getActivity().startActivity(intent);
//            getActivity().finish();
//        } else
            {
//            UserComponent userComponent =
//                    IMAccountLifeCycle.imAccountLifeCycle.getComponent();
//            this.useCaseComponent = DaggerUseCaseComponent.builder()
//                    .userComponent(userComponent)
//                    .build();
//            MsgDisplay msgDisplay = this.useCaseComponent.msgDisplay();
//            this.okHandler = new OkHandlerImp<>(msgDisplay);
        }
        
    }
    @Override
    public void onResume() {
        super.onResume();
        NotificationUtil.getInstance().clearPNNotification();
    }
}
