package com.xdja.im.lib.filemanage.view;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;

import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.model.GridItemBean;
import com.xdja.im.lib.filemanage.presenter.BasePresenterActivity;
import com.xdja.im.lib.filemanage.util.FileInfoCollection;
import com.xdja.im.lib.filemanage.util.HistoryFileUtils;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.lib.video.utils.UnitUtil;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.image.BitmapUtils;


public class ViewLastVideoItem extends ViewLastBaseItem {

    private CheckBox isSelect;
    private ImageView imgView;
    private TextView videoTime;
    private int style;
    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_file_image_fragment_video;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = getView();
        style = UniversalUtil.getThemeStyle(getContext());
        if (view != null) {
            isSelect = (CheckBox) view.findViewById(R.id.chx_video_file_select);
            imgView = (ImageView) view.findViewById(R.id.history_file_video_img);
            videoTime = (TextView) view.findViewById(R.id.history_file_video_time);
        }
    }

    @Override
    public void bindDataSource(int position, @NonNull GridItemBean dataSource) {
        super.bindDataSource(position, dataSource);
        final TalkMessageBean dataTalk = (TalkMessageBean) dataSource.getValue();
        final FileInfo fileInfo = dataTalk.getFileInfo();

        isSelect.setVisibility(View.VISIBLE);
        isSelect.setChecked(dataTalk.isChecked());
        isSelect.setClickable(false);

        isSelect.setButtonDrawable(dataTalk.isChecked() ? (style ==
                BasePresenterActivity.THEME_DARK ? R.drawable.im_uikit_icon_selected_on : R.drawable.im_uikit_icon_selected_on_light) :
                R.drawable.im_uikit_icon_selected_off);

        isSelect.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                dataTalk.setChecked(isChecked);

                isSelect.setButtonDrawable(isChecked ? (style ==
                        BasePresenterActivity.THEME_DARK ? R.drawable.im_uikit_icon_selected_on : R.drawable.im_uikit_icon_selected_on_light) :
                        R.drawable.im_uikit_icon_selected_off);

                FileInfo fileExtraInfo = ((VideoFileInfo)fileInfo).getRawFileInfo();
                FileItem localFileInfo = new FileItem(fileExtraInfo.getFileName(), fileExtraInfo.getFilePath(),
                        fileExtraInfo.getFileSize(), 0, fileInfo.getFileType());

                if (isChecked) {
                    FileInfoCollection.getInstance().putFileToSelectedCache(fileInfo.getFilePath()+ dataTalk.getId(), localFileInfo);
                } else {
                    FileInfoCollection.getInstance().removeToSelectedCache(fileInfo.getFilePath()+ dataTalk.getId());
                }
                getCommand().toRefreshSelectHint(localFileInfo);
            }
        });


        VideoFileInfo videoFileInfo = (VideoFileInfo) dataTalk.getFileInfo();
        if (videoFileInfo != null) {
            if (HistoryFileUtils.isFileExist(videoFileInfo.getFilePath())) {
                loadImage(videoFileInfo.getFilePath());
            } else {
                loadImage(null);
            }

            videoTime.setText(UnitUtil.getVideoDuration(videoFileInfo.getAmountOfTime()));
        }
    }

    private void loadImage(String filePath) {
        if (TextUtils.isEmpty(filePath)) {
            imgView.setImageResource(R.drawable.im_uikit_pic_failed);
        } else {
            imgView.setImageBitmap(BitmapUtils.getZoomedDrawable(filePath, 1));
        }
    }
}
