package com.xdja.im.lib.video.ui.activity;

import android.Manifest;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.hardware.Camera;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;

import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.common.utils.PermissionUtils;
import com.xdja.im.lib.video.bean.VideoItem;
import com.xdja.im.lib.video.ui.presenter.VideoRecorderPresenter;
import com.xdja.im.lib.video.ui.view.ViewVideoRecorder;
import com.xdja.im.lib.video.ui.view.vu.VideoRecorderVu;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImBaseActivity;
import com.xdja.im.uikit.constans.Constant;
import com.xdja.im.uikit.utils.log.LogUtil;

/**
 * @Package: com.xdja.im.lib.video
 * @Author: xdjaxa
 * @Creation: 2017-04-24 9:13
 * @Version V1.0
 * @Description:
 */
public class VideoRecorderActivity extends ImBaseActivity<VideoRecorderPresenter, VideoRecorderVu>
        implements VideoRecorderPresenter {
    @NonNull
    @Override
    protected Class<? extends VideoRecorderVu> getVuClass() {
        return ViewVideoRecorder.class;
    }

    @NonNull
    @Override
    protected VideoRecorderPresenter getPresenter() {
        return this;
    }


    @Override
    protected void preBindView(@Nullable Bundle savedInstanceState) {
        super.preBindView(savedInstanceState);
        //设置全屏
        getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION);
        getWindow().addFlags(View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION);
    }

    @Override
    protected void onBindView(@Nullable Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);

        //请求相机权限
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
            openCamera();
        } else {
            requestPermission();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if (getVu().isCompleteRecord()) {
            getVu().getVideoManager().resume();
        } else {
            getVu().cancelAndRerecord();
        }
    }


    /**
     * 尝试打开相机
     */
    private void openCamera() {
        Camera camera = null;
        try {
            camera = Camera.open(0);
            //开始视频预览
            getVu().startPreview();
        } catch (Exception e) {
            LogUtil.e("ERROR: Open camera error.");
            CommonTool.showToast(R.string.im_uikit_camera_deny_for_occupy);
            finish();
        } finally {
            if (camera != null) {
                camera.release();
                camera = null;
            }
        }
    }

    /**
     * 权限申请
     */
    private void requestPermission() {
        if (PermissionUtils.hasSelfPermissions(this,
                Manifest.permission.CAMERA,
                Manifest.permission.RECORD_AUDIO,
                Manifest.permission.READ_EXTERNAL_STORAGE,
                Manifest.permission.WRITE_EXTERNAL_STORAGE)) {
            //开始视频预览
            getVu().startPreview();
        } else {
            //请求权限
            PermissionUtils.requestPermissions(this,
                    new String[]{Manifest.permission.CAMERA,
                            Manifest.permission.RECORD_AUDIO,
                            Manifest.permission.READ_EXTERNAL_STORAGE,
                            Manifest.permission.WRITE_EXTERNAL_STORAGE},
                    Constant.REQUEST_PERMISSION_CAMERA);
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == Constant.REQUEST_PERMISSION_CAMERA) {
            if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {

                if (grantResults[1] != PackageManager.PERMISSION_GRANTED) {
                    showToast(R.string.im_uikit_audio_deny);
                    finish();
                } else if (grantResults.length >= 4 && grantResults[2] != PackageManager.PERMISSION_GRANTED ||
                        grantResults[3] != PackageManager.PERMISSION_GRANTED) {
                    showToast(R.string.im_uikit_storage_deny);
                    finish();
                } else {

                    //开始视频预览
                    getVu().startPreview();
                }
            } else {
                showToast(R.string.im_uikit_camera_deny);
                finish();
            }
        }
    }

    @Override
    public void sendVideoMessage(VideoItem videoItem) {

        Intent intent = new Intent();
        //数据绑定
        Bundle bundle = new Bundle();
        bundle.putParcelable(Constant.TAG_VIDEO_RECORDER, videoItem);
        //添加数据到Intent
        intent.putExtras(bundle);
        //返回结果
        setResult(Constant.RESULT_CODE_VIDEO, intent);
        finish();
    }

    @Override
    public void onBackPressed() {
        //code = 1 为返回重新录制
        int code = getVu().onKeyBack();
        if (code == 1) {
            return;
        }
        super.onBackPressed();
    }

    @Override
    public void onPause() {
        if (getVu().isCompleteRecord()) {
            getVu().getVideoManager().release();
        } else {
            getVu().cancelAndRerecord();
        }
        super.onPause();
    }

    @Override
    public void onDestroy() {
        getVu().getVideoManager().stopPlay(false);
        super.onDestroy();
    }

}
