package com.xdja.im.uikit.action.media;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import android.os.PowerManager;

import com.xdja.im.uikit.ImUiKit;

import static android.media.AudioManager.FLAG_SHOW_UI;

/**
 * @Package: com.xdja.im.common.media
 * @Author: xdjaxa
 * @Creation: 2017-09-15 10:51
 * @Version V1.0
 * @Description:媒体播放器管理类
 */
public class MediaManger {

    /**
     * 外放模式
     */
    public static final int MODE_SPEAKER = 0;

    /**
     * 耳机模式
     */
    public static final int MODE_HEADSET = 1;

    /**
     * 听筒模式
     */
    public static final int MODE_EARPIECE = 2;

    /**
     * 上下文
     */
    private Context context;

    /**
     * 音频播放器
     */
    private AudioManager mAudioManager;

    /**
     * 是否熄灭屏幕
     */
    private boolean isWakeAcquire = false;

    /**
     * 当前音频播放模式
     */
    private int mCurrentMode = MODE_SPEAKER;

    private PowerManager.WakeLock mWakeLock;

    private static class SingletonInstance {
        private static final MediaManger mInstance = new MediaManger();
    }

    public static MediaManger getInstance() {
        return SingletonInstance.mInstance;
    }

    private MediaManger() {
        context = ImUiKit.getInstance().getContext();
        mAudioManager = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);
    }

    /**
     * 初始化音频管理器
     */
    public void initAudioManager() {
        //mAudioManager = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);
        /*if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
            mAudioManager.setMode(AudioManager.MODE_IN_COMMUNICATION);
        } else {
            mAudioManager.setMode(AudioManager.MODE_IN_CALL);
        }
        mAudioManager.setSpeakerphoneOn(true);*/

        //电源管理模块
        PowerManager pManager = (PowerManager) context
                .getSystemService(Context.POWER_SERVICE);
        mWakeLock = pManager.newWakeLock(PowerManager.PROXIMITY_SCREEN_OFF_WAKE_LOCK, "");
    }

    public void resetAudioManager() {
        //mAudioManager.setMode(AudioManager.MODE_NORMAL);
        mAudioManager.setSpeakerphoneOn(true);
    }

    /**
     * 获取当前播放模式
     *
     * @return
     */
    public int getCurrentMode() {
        return mCurrentMode;
    }

    /**
     * 切换到听筒模式
     */
    public void changeToEarpieceMode() {
//        if (mCurrentMode == MODE_EARPIECE) {
//            return;
//        }
        mCurrentMode = MODE_EARPIECE;
        //设置为通话模式
        mAudioManager.setMode(AudioManager.MODE_IN_COMMUNICATION);
        mAudioManager.setSpeakerphoneOn(false);
    }

    /**
     * 切换到耳机模式
     */
    public void changeToHeadsetMode() {
//        if (mCurrentMode == MODE_HEADSET) {
//            return;
//        }
        mCurrentMode = MODE_HEADSET;
        mAudioManager.setSpeakerphoneOn(false);
    }

    /**
     * 切换到外放模式
     */
    public void changeToSpeakerMode() {
//        if (mCurrentMode == MODE_SPEAKER) {
//            return;
//        }
        mCurrentMode = MODE_SPEAKER;
        //mAudioManager.setMode(AudioManager.MODE_NORMAL);
        mAudioManager.setSpeakerphoneOn(true);
    }

    /**
     * 申请设备电源锁，灭屏
     */
    public void wakeLockBrightAcquire() {
        if (mWakeLock != null && !mWakeLock.isHeld()) {
            isWakeAcquire = true;
            mWakeLock.setReferenceCounted(false);
            mWakeLock.acquire();
        }
    }

    public boolean isWakeAcquire(){
       return isWakeAcquire;
    }

    /**
     * 释放电源设备锁，亮屏
     */
    public void wakeLockBrightRelease() {
        if (mWakeLock != null && mWakeLock.isHeld()) {
            isWakeAcquire = false;
            mWakeLock.release();
        }
    }

    /**
     * 调大音量
     */
    public void raiseVolume() {
        int currentVolume = mAudioManager.getStreamVolume(AudioManager.STREAM_MUSIC);
        if (currentVolume < mAudioManager.getStreamMaxVolume(AudioManager.STREAM_MUSIC)) {
            mAudioManager.adjustStreamVolume(AudioManager.STREAM_MUSIC,
                    AudioManager.ADJUST_RAISE, AudioManager.FX_FOCUS_NAVIGATION_UP);
        }
    }

    /**
     * 调小音量
     */
    public void lowerVolume() {
        int currentVolume = mAudioManager.getStreamVolume(AudioManager.STREAM_MUSIC);
        if (currentVolume > 0) {
            mAudioManager.adjustStreamVolume(AudioManager.STREAM_MUSIC,
                    AudioManager.ADJUST_LOWER, AudioManager.FX_FOCUS_NAVIGATION_UP);
        }
    }

    public void raiseVolume(Context context) {
        setVolume(context, true);
    }

    public void lowerVolume(Context context) {
        setVolume(context, false);
    }

    private void setVolume(Context context, boolean upVolume) {
        int volume = mAudioManager.getStreamVolume(AudioManager.STREAM_MUSIC);
        if (upVolume) {
            volume += 1;
        } else {
            volume -= 1;
        }
        int maxVolume = mAudioManager.getStreamMaxVolume(AudioManager.STREAM_MUSIC);
        if (volume >= 0 && volume <= maxVolume) {
            mAudioManager.setStreamVolume(AudioManager.STREAM_MUSIC, volume, FLAG_SHOW_UI);
        }
    }

    /**
     * 还原音频mode，音频停止播放时调用
     */
    public void restoreAudioMode() {
        mAudioManager.setMode(AudioManager.MODE_NORMAL);
    }

    public void setAudioMode() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
            mAudioManager.setMode(AudioManager.MODE_IN_COMMUNICATION);
        } else {
            mAudioManager.setMode(AudioManager.MODE_IN_CALL);
        }
    }

    public void releaseSpeakerphone(){
        mAudioManager.setSpeakerphoneOn(false);
    }
}
