package com.xdja.im.uikit.constans;

import android.support.annotation.IntDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * @Package:com.xdja.im.uikit.config
 * @Author:Lei
 * @Creation:2017-04-12 23:41
 * @Version 1.0
 * @Description:
 */
public class Constant {

    /**
     * 获取聊天对象的的TAG
     */
    public static final String TAG_TALKERID = "talkerId";
    /**
     * 会话类型的TAG
     */
    public static final String TAG_TALKTYPE = "talkType";
    /**
     * 会话类型的flag
     */
    public static final String TAG_TALKFLAG = "talkFlag";
    /**
     * 消息flag
     */
    public static final String TAG_MSGID = "messageId";
    /**
     * 文件状态flag
     */
    public static final String TAG_FILE_STATE = "fileState";
    /**
     * 文件下载进度flag
     */
    public static final String TAG_FILE_TRANS_SIZE = "fileTranslateSize";
    /**
     * 同步时间差Key
     */
    public static final String KEY_TIME_DIFFERENT = "diff";


    //***************************************************************
    //                      聊天界面Item类型定义
    //***************************************************************
    @Retention(RetentionPolicy.SOURCE)
    @IntDef(value = {
            ITEM_TYPE_SEND_TEXT,
            ITEM_TYPE_RECEIVE_TEXT,
            ITEM_TYPE_SEND_VOICE,
            ITEM_TYPE_RECEIVE_VOICE,
            ITEM_TYPE_SEND_IMAGE,
            ITEM_TYPE_RECEIVE_IMAGE,
            ITEM_TYPE_SEND_VIDEO,
            ITEM_TYPE_RECEIVE_VIDEO,
            ITEM_TYPE_SEND_FILE,
            ITEM_TYPE_RECEIVE_FILE,
            ITEM_TYPE_SEND_WEB,
            ITEM_TYPE_RECEIVE_WEB,
            ITEM_TYPE_SEND_LOCATION,
            ITEM_TYPE_RECEIVE_LOCATION,
            ITEM_TYPE_SEND_CUSTOM,
            ITEM_TYPE_REC_CUSTOM,
            ITEM_TYPE_NOTIFY,
            ITEM_TYPE_DEFAULT})
    public @interface ChatItemType {
    }


    /**
     * 发送的文本
     */
    public static final int ITEM_TYPE_SEND_TEXT = 0;

    /**
     * 接收的文本
     */
    public static final int ITEM_TYPE_RECEIVE_TEXT = 1;

    /**
     * 发送的語音
     */
    public static final int ITEM_TYPE_SEND_VOICE = 2;

    /**
     * 接收的語音
     */
    public static final int ITEM_TYPE_RECEIVE_VOICE = 3;

    /**
     * 发送的图片
     */
    public static final int ITEM_TYPE_SEND_IMAGE = 4;

    /**
     * 接收的图片
     */
    public static final int ITEM_TYPE_RECEIVE_IMAGE = 5;

    /**
     * 发送的小视频
     */
    public static final int ITEM_TYPE_SEND_VIDEO = 6;

    /**
     * 接收的小视频
     */
    public static final int ITEM_TYPE_RECEIVE_VIDEO = 7;
    /**
     * 发送的文件
     */
    public static final int ITEM_TYPE_SEND_FILE = 8;

    /**
     * 接收的文件
     */
    public static final int ITEM_TYPE_RECEIVE_FILE = 9;
    /**
     * 发送的图文消息
     */
    public static final int ITEM_TYPE_SEND_WEB = 10;

    /**
     * 接收的图文消息
     */
    public static final int ITEM_TYPE_RECEIVE_WEB = 11;
    /**
     * 发送的位置信息
     */
    public static final int ITEM_TYPE_SEND_LOCATION = 12;
    /**
     * 接收的位置信息
     */
    public static final int ITEM_TYPE_RECEIVE_LOCATION = 13;
    /**
     * 通知类型
     */
    public static final int ITEM_TYPE_NOTIFY = 14;
    /**
     * 自定义类型
     */
    public static final int ITEM_TYPE_SEND_CUSTOM = 15;
    /**
     * 默认类型
     */
    public static final int ITEM_TYPE_DEFAULT = 16;
    /**
     * 自定义
     */
    public static final int ITEM_TYPE_REC_CUSTOM = 17;

    //***************************************************************
    //                      文件预览界面类型
    //***************************************************************
    @Retention(RetentionPolicy.SOURCE)
    @IntDef(value = {
            ITEM_TYPE_IMAGE,
            ITEM_TYPE_VIDEO,
            ITEM_TYPE_FILE})
    public @interface FileItemType {
    }

    /**
     * 图片类型
     */
    public static final int ITEM_TYPE_IMAGE = 0;

    /**
     * 视频类型
     */
    public static final int ITEM_TYPE_VIDEO = 1;

    /**
     * 文件类型
     */
    public static final int ITEM_TYPE_FILE = 2;

    //***************************************************************
    //                      消息Pop选项
    //***************************************************************
    @Retention(RetentionPolicy.SOURCE)
    @IntDef(value = {ITEM_CHAT_DELETE, ITEM_CHAT_COPY, ITEM_CHAT_RECALL, ITEM_CHAT_RESEND})
    public @interface ChatOption {
    }

    /**
     * 删除消息
     */
    public static final int ITEM_CHAT_DELETE = 1;
    /**
     * 复制消息
     */
    public static final int ITEM_CHAT_COPY = 2;
    /**
     * 消息撤回
     */
    public static final int ITEM_CHAT_RECALL = 3;
    /**
     * 消息重发
     */
    public static final int ITEM_CHAT_RESEND = 4;

    @Retention(RetentionPolicy.SOURCE)
    @IntDef(value = {ITEM_SESSION_DELETE, ITEM_SESSION_SETTOP, ITEM_SESSION_CANCELTOP,
            ITEM_SESSION_SETDISTURB, ITEM_SESSION_CLOSEDISTURB})
    public @interface SessionOption {
    }

    /**
     * 删除会话
     */
    public static final int ITEM_SESSION_DELETE = 1;
    /**
     * 置顶会话
     */
    public static final int ITEM_SESSION_SETTOP = 2;
    /**
     * 取消置顶
     */
    public static final int ITEM_SESSION_CANCELTOP = 3;
    /**
     * 开启免打扰
     */
    public static final int ITEM_SESSION_SETDISTURB = 4;
    /**
     * 关闭免打扰
     */
    public static final int ITEM_SESSION_CLOSEDISTURB = 5;

    //***************************************************************
    //                      设备类型（项目类型）
    //***************************************************************
    @Retention(RetentionPolicy.SOURCE)
    @IntDef(value = {DEVICE_PHONE, DEVICE_PC})
    public @interface DEVICETYPE {
    }

    /**
     * 手机设备
     */
    public static final int DEVICE_PHONE = 1;
    /**
     * PC端设备
     */
    public static final int DEVICE_PC = 2;

    //***************************************************************
    //                      平台类型
    //***************************************************************
    @Retention(RetentionPolicy.SOURCE)
    @IntDef(value = {PLATFORM_COMMON, PLATFORM_OA})
    public @interface PLATFORMTYPE {
    }

    /**
     * 通用项目
     */
    public static final int PLATFORM_COMMON = 0;
    /**
     * 目前OA项目支持
     */
    public static final int PLATFORM_OA = 1;


    //***************************************************************
    //                      Activity返回状态码
    //***************************************************************
    /**
     * 表情返回状态码
     */
    public static final int RESULT_CODE_EMOTION = 0x001;
    /**
     * 图库返回状态码
     */
    public static final int RESULT_CODE_ALBUM = 0x002;
    /**
     * 相册返回状态码
     */
    public static final int RESULT_CODE_CAMERA = 0x003;
    /**
     * 音频返回状态码
     */
    public static final int RESULT_CODE_AUDIO = 0x004;
    /**
     * 视频返回状态码
     */
    public static final int RESULT_CODE_VIDEO = 0x005;
    /**
     * 文件返回状态码
     */
    public static final int RESULT_CODE_FILE = 0x006;
    /**
     * 位置返回状态码
     */
    public static final int RESULT_CODE_LOCATION = 0x007;
    /**
     * 网页返回状态码
     */
    public static final int RESULT_CODE_WEB = 0x008;

    /**
     * 文件查看界面返回码
     */
    public static final int RESULT_CODE_FILE_DOWNLOAD = 0x009;


    //***************************************************************
    //                      权限申请返回状态码
    //***************************************************************
    /**
     * 读写存储
     */
    public static final int REQUEST_PERMISSION_STORAGE = 0x01;
    /**
     * 相机权限
     */
    public static final int REQUEST_PERMISSION_CAMERA = 0x02;
    /**
     * 录音权限
     */
    public static final int REQUEST_PERMISSION_RECORD_AUDIO = 0x03;

    //***************************************************************
    //             以下为Activity、Fragment之间传递数据tag值
    //                   TODO 以后需放入对应的lib中
    //***************************************************************
    public static final String TAB_TYPE = "tab_type";
    /**
     * 缩略图tag
     */
    public static final String TAG_PIC_SELECT = "album_pic_select";
    /**
     * 小视频tag
     */
    public static final String TAG_VIDEO_RECORDER = "im_uikit_video_recorder";
    /**
     * 文件tag
     */
    public static final String TAG_FILE_SELECT = "file_select";
    /**
     * 照片tag
     */
    public static final String TAG_PHOTO = "album_photo";

    /**
     * 对方不是好友
     */
    public static final int FAIL_FRIEND = -5;
}
