/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.model.message.mapper;

import android.text.TextUtils;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.utils.IMFileTools;
import com.xdja.imsdk.constant.ImSdkFileConstant;
import com.xdja.imsdk.model.IMMessage;
import com.xdja.imsdk.model.body.IMFileBody;

public class ValueConverter {
    public static int sessionTypeConvert(int sessionType) {
        switch (sessionType) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 100: {
                return 999;
            }
        }
        return 0;
    }

    public static int talkListTypeConvert(int chatType) {
        return 0;
    }

    public static int imMsgStateConvert(int imMsgState) {
        int state = 1;
        switch (imMsgState) {
            case 0: {
                state = 1;
                break;
            }
            case -1: {
                state = 0;
                break;
            }
            case 1: {
                state = 2;
                break;
            }
            case 2: {
                state = 3;
                break;
            }
            case 3: {
                state = 4;
                break;
            }
            case 4: {
                state = 5;
                break;
            }
            case 5: {
                state = 7;
                break;
            }
        }
        return state;
    }

    public static int talkMsgStateConvert(int talkMsgState) {
        int state = 0;
        switch (talkMsgState) {
            case 6: {
                break;
            }
            case 1: {
                state = 0;
                break;
            }
            case 0: {
                state = -1;
                break;
            }
            case 2: {
                state = 1;
                break;
            }
            case 3: {
                state = 2;
                break;
            }
            case 4: {
                state = 3;
                break;
            }
            case 5: {
                state = 4;
                break;
            }
        }
        return state;
    }

    public static int talkMsgTypeConvert(TalkMessageBean messageBean) {
        int talkMsgType = messageBean.getMessageType();
        if (!messageBean.isGroupMsg()) {
            if (talkMsgType == 5) {
                return 64;
            }
            if (messageBean.isBomb()) {
                if (talkMsgType == 0) {
                    return 9;
                }
                return 10;
            }
            if (talkMsgType == 101) {
                return 32769;
            }
            if (talkMsgType == 0) {
                return 1;
            }
            if (talkMsgType == 102) {
                return 65537;
            }
            return 2;
        }
        if (messageBean.isBomb()) {
            if (talkMsgType == 0) {
                return 13;
            }
            return 14;
        }
        if (talkMsgType == 101) {
            return 32773;
        }
        if (talkMsgType == 0) {
            return 5;
        }
        if (talkMsgType == 102) {
            return 65541;
        }
        return 6;
    }

    public static int imMsgTypeConvert(IMMessage imMessage) {
        if ((imMessage.getType() & 0x8000) == 32768) {
            return 101;
        }
        if (imMessage.isTextIMMessage()) {
            return 0;
        }
        if (imMessage.isFileIMMessage()) {
            return ValueConverter.imFileTypeConvert((IMFileBody)imMessage.getMessageBody());
        }
        if (imMessage.isATMessage()) {
            return 14;
        }
        return -1;
    }

    public static int imFileTypeConvert(IMFileBody imFileBody) {
        int fileType = imFileBody.getType();
        switch (fileType) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 0: {
                return 4;
            }
        }
        return 101;
    }

    public static int imNormalFileTypeConvert(IMFileBody imFileBody) {
        String suffix = imFileBody.getSuffix();
        if (TextUtils.isEmpty((CharSequence)suffix)) {
            suffix = IMFileTools.getSuffixFromFilepath(imFileBody.getLocalPath());
        }
        switch (suffix) {
            case "txt": {
                return 5;
            }
            case "doc": 
            case "docx": {
                return 6;
            }
            case "ppt": 
            case "pptx": {
                return 7;
            }
            case "xls": 
            case "xlsx": {
                return 8;
            }
            case "pdf": 
            case "pps": {
                return 9;
            }
            case "rar": 
            case "zip": 
            case "gz": {
                return 10;
            }
            case "apk": {
                return 4;
            }
        }
        return 11;
    }

    public static ImSdkFileConstant.FileGetType changeObtainFileType(int type) {
        ImSdkFileConstant.FileGetType getType = ImSdkFileConstant.FileGetType.OTHER;
        switch (type) {
            case 0: {
                getType = ImSdkFileConstant.FileGetType.EXIST_ALL;
                break;
            }
            case 1: {
                getType = ImSdkFileConstant.FileGetType.CUR_ALL_MEDIA;
                break;
            }
            case 2: {
                getType = ImSdkFileConstant.FileGetType.OTHER;
                break;
            }
            case 3: {
                getType = ImSdkFileConstant.FileGetType.CUR_ALL;
            }
        }
        return getType;
    }
}

