/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.action;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Toast;
import com.xdja.im.lib.action.listener.IChatActionCallback;
import com.xdja.im.lib.audio.widget.AudioRecorderButton;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.view.PastEditText;

public class ChatInputView
extends LinearLayout {
    private final int MAX_INPUT_SIZE = 2048;
    private ImageView mMoreImg;
    private ImageView mShanImg;
    private CheckBox mInputSwitchChx;
    private PastEditText mInputEdt;
    private AudioRecorderButton mRecorderBtn;
    private Button mSendBtn;
    private boolean isInitFirst;
    private String groupId;
    private String account;
    private int mChatType = 1;
    private Toast mToast;
    private boolean isDraft = false;
    boolean isTouchEditText;

    public void setChatType(int chatType) {
        this.mChatType = chatType;
    }

    public void setIsDraft(boolean isDraft) {
        this.isDraft = isDraft;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public ChatInputView(Context context) {
        super(context);
        this.initView();
    }

    public ChatInputView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public ChatInputView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        View.inflate((Context)this.getContext(), (int)R.layout.im_uikit_layout_chat_operate, (ViewGroup)this);
        this.isInitFirst = true;
        this.mMoreImg = (ImageView)this.findViewById(R.id.img_more_action);
        this.mShanImg = (ImageView)this.findViewById(R.id.img_shan_action);
        this.mInputSwitchChx = (CheckBox)this.findViewById(R.id.chx_input_switch);
        this.mInputEdt = (PastEditText)this.findViewById(R.id.edt_input_text);
        this.mRecorderBtn = (AudioRecorderButton)this.findViewById(R.id.btn_input_voice);
        this.mSendBtn = (Button)this.findViewById(R.id.btn_send);
    }

    public void registerActionViewCallBack(final IChatActionCallback callback) {
        this.mInputEdt.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                s.length();
            }

            public void afterTextChanged(Editable s) {
                int length = s.toString().length();
                if (length >= 2048) {
                    s = s.delete(2048, length);
                }
                if (s.length() == 0) {
                    ChatInputView.this.mSendBtn.setVisibility(8);
                    ChatInputView.this.mMoreImg.setVisibility(0);
                } else if (ChatInputView.this.isInitFirst && !ChatInputView.this.mInputEdt.hasFocus()) {
                    ChatInputView.this.mSendBtn.setVisibility(8);
                    ChatInputView.this.mMoreImg.setVisibility(0);
                    ChatInputView.this.isInitFirst = false;
                } else {
                    ChatInputView.this.mSendBtn.setVisibility(0);
                    ChatInputView.this.mMoreImg.setVisibility(8);
                }
            }
        });
        this.mInputEdt.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                ChatInputView.this.mInputEdt.setFocusable(true);
                ChatInputView.this.mInputEdt.setFocusableInTouchMode(true);
                ChatInputView.this.mInputEdt.requestFocus();
                if (!TextUtils.isEmpty((CharSequence)ChatInputView.this.getInputText())) {
                    ChatInputView.this.isDraft = true;
                    ChatInputView.this.mSendBtn.setVisibility(0);
                    ChatInputView.this.mMoreImg.setVisibility(8);
                }
                if (event.getAction() == 1) {
                    ChatInputView.this.isTouchEditText = true;
                    ChatInputView.this.mMoreImg.setImageResource(R.mipmap.im_uikit_action_chat_panel_normal);
                    callback.onInputEareTouchCallBack();
                }
                return false;
            }
        });
        this.mInputSwitchChx.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                ChatInputView.this.switchToInputEdt(!isChecked);
                callback.onInputCheckChanged(!isChecked);
            }
        });
        this.mShanImg.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChatInputView.this.setMoreState(false);
                ChatInputView.this.switchToInputEdt(true);
                ChatInputView.this.mInputSwitchChx.setChecked(false);
                callback.onShanCheckChanged();
            }
        });
        this.mMoreImg.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChatInputView.this.setShanState(false);
                ChatInputView.this.switchToInputEdt(true);
                ChatInputView.this.mInputSwitchChx.setChecked(false);
                callback.onMoreCheckChanged();
            }
        });
        this.mSendBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                callback.onSendTextCallBack();
            }
        });
        this.mRecorderBtn.setAudioFinishRecorderListener(new AudioRecorderButton.AudioFinishRecorderListener(){

            @Override
            public void onFinish(float seconds, String filePath) {
                callback.onRecorderFinish((int)seconds, filePath);
            }
        });
        this.mInputEdt.setFilters(new InputFilter[]{new CusInputFilter()});
    }

    public void switchToInputEdt(boolean isSwitch) {
        if (isSwitch) {
            this.mInputEdt.setVisibility(0);
            this.mRecorderBtn.setVisibility(8);
            this.mInputEdt.requestFocus();
            if (this.getInputEdt().length() == 0) {
                this.mSendBtn.setVisibility(8);
                this.mMoreImg.setVisibility(0);
            } else {
                this.mSendBtn.setVisibility(0);
                this.mMoreImg.setVisibility(8);
            }
        } else {
            this.mInputEdt.setVisibility(8);
            this.mRecorderBtn.setVisibility(0);
            this.mSendBtn.setVisibility(8);
            this.mMoreImg.setVisibility(0);
        }
    }

    public String getInputText() {
        return this.mInputEdt.getText().toString();
    }

    public void setInputText(CharSequence text) {
        this.mInputEdt.setText((CharSequence)EmotionUtils.formatNormalSpanContent(text, this.getContext()));
        this.mInputEdt.setFocusable(true);
        this.mInputEdt.setFocusableInTouchMode(true);
        this.mInputEdt.requestFocus();
        this.mInputEdt.setSelection(EmotionUtils.formatNormalSpanContent(text, this.getContext()).length());
    }

    public EditText getInputEdt() {
        return this.mInputEdt;
    }

    public void setMoreState(boolean isChecked) {
        if (!TextUtils.isEmpty((CharSequence)this.getInputText()) && this.mInputEdt.isShown()) {
            this.mMoreImg.setVisibility(8);
            this.mSendBtn.setVisibility(0);
            this.mInputEdt.requestFocus();
        } else {
            this.mSendBtn.setVisibility(8);
            this.mMoreImg.setVisibility(0);
            if (isChecked) {
                this.mMoreImg.setImageResource(R.mipmap.im_uikit_actioin_chat_panel_press);
            } else {
                this.mMoreImg.setImageResource(R.mipmap.im_uikit_action_chat_panel_normal);
            }
        }
    }

    public void setShanState(boolean isChecked) {
        if (isChecked) {
            this.mShanImg.setImageResource(R.mipmap.im_uikit_action_chat_keyinput_normal);
        } else {
            this.mShanImg.setImageResource(R.mipmap.im_uikit_action_chat_emotion_normal);
        }
    }

    private boolean canAtFriend(CharSequence charSequence) {
        String str = this.mInputEdt.getText().toString();
        String string2 = str.substring(0, this.mInputEdt.getSelectionEnd());
        return (this.mInputEdt.getText().length() == 0 || !ChatInputView.englishOrDigital(string2)) && charSequence.toString().equalsIgnoreCase("@");
    }

    private static boolean englishOrDigital(String str) {
        if (str == null) {
            return false;
        }
        return str.length() >= 1 && ChatInputView.englishOrDigital(str.charAt(str.length() - 1));
    }

    private static boolean englishOrDigital(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private class CusInputFilter
    implements InputFilter {
        private CusInputFilter() {
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            if (!ChatInputView.this.isDraft && ChatInputView.this.mChatType == 2 && ChatInputView.this.canAtFriend(source)) {
                Toast.makeText((Context)ChatInputView.this.getContext(), (CharSequence)"\u901a\u8fc7@\u8df3\u8f6c\u5230\u7fa4\u7ec4\u9875\u9762", (int)0).show();
            }
            return null;
        }
    }
}

