/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.action.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.xdja.im.lib.action.bean.OptionBean;
import com.xdja.im.uikit.R;
import java.util.List;

public class ActionMenuAdapter
extends BaseAdapter {
    private Context mContext;
    private List<OptionBean> mOptions;

    public ActionMenuAdapter(Context context, List<OptionBean> options) {
        this.mContext = context;
        this.mOptions = options;
    }

    public int getCount() {
        return this.mOptions == null ? 0 : this.mOptions.size();
    }

    public Object getItem(int position) {
        return this.mOptions.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        if (convertView == null) {
            convertView = View.inflate((Context)this.mContext, (int)R.layout.im_uikit_item_chat_action_menu, null);
            viewHolder = new ViewHolder(convertView);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        viewHolder.bindData(this.mOptions.get(position));
        return convertView;
    }

    public int getImgRes(String resOps) {
        if (TextUtils.isEmpty((CharSequence)resOps)) {
            return -1;
        }
        String type = resOps.substring(resOps.indexOf(".") + 1, resOps.lastIndexOf("."));
        String name = resOps.substring(resOps.lastIndexOf(".") + 1);
        switch (type) {
            case "drawable": {
                return this.mContext.getResources().getIdentifier(name, "drawable", this.mContext.getPackageName());
            }
            case "mipmap": {
                return this.mContext.getResources().getIdentifier(name, "mipmap", this.mContext.getPackageName());
            }
        }
        return -1;
    }

    public int getMenuName(String resOps) {
        String name = resOps.substring(resOps.lastIndexOf(".") + 1);
        return this.mContext.getResources().getIdentifier(name, "string", this.mContext.getPackageName());
    }

    class ViewHolder {
        private ImageView iconImg;
        private TextView menuNameTv;

        public ViewHolder(View itemView) {
            this.iconImg = (ImageView)itemView.findViewById(R.id.img_chat_menu);
            this.menuNameTv = (TextView)itemView.findViewById(R.id.tv_chat_menu);
        }

        public void bindData(OptionBean bean) {
            this.iconImg.setImageResource(ActionMenuAdapter.this.getImgRes(bean.getIcon()));
            this.menuNameTv.setText(ActionMenuAdapter.this.getMenuName(bean.getLabel()));
        }
    }
}

