/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.file.widget.recyclerview;

import com.xdja.im.lib.file.widget.recyclerview.ItemViewDelegate;
import com.xdja.im.lib.file.widget.recyclerview.ViewHolder;
import java.util.HashMap;
import java.util.Map;

public class ItemViewDelegateManager<T> {
    private Map<Integer, ItemViewDelegate<T>> delegates = new HashMap<Integer, ItemViewDelegate<T>>();

    public int getItemViewDelegateCount() {
        return this.delegates.size();
    }

    public ItemViewDelegateManager<T> addDelegate(ItemViewDelegate<T> delegate) {
        int viewType = this.delegates.size();
        if (delegate != null) {
            this.delegates.put(viewType, delegate);
            ++viewType;
        }
        return this;
    }

    public ItemViewDelegateManager<T> addDelegate(int viewType, ItemViewDelegate<T> delegate) {
        if (this.delegates.get(viewType) == null) {
            this.delegates.put(viewType, delegate);
        }
        return this;
    }

    public int getItemViewType(T item, int position) {
        for (Map.Entry<Integer, ItemViewDelegate<T>> entry : this.delegates.entrySet()) {
            ItemViewDelegate<T> delegate = entry.getValue();
            if (!delegate.isForViewType(item, position)) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("No Item to match!");
    }

    public void covert(ViewHolder viewHolder, T item, int position) {
        for (Map.Entry<Integer, ItemViewDelegate<T>> entry : this.delegates.entrySet()) {
            ItemViewDelegate<T> delegate = entry.getValue();
            if (!delegate.isForViewType(item, position)) continue;
            delegate.covert(viewHolder, item, position);
            return;
        }
        throw new IllegalArgumentException("No Item to convert!");
    }

    public ItemViewDelegate getItemViewDelegate(int viewType) {
        return this.delegates.get(viewType);
    }
}

