/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.presenter;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.xdja.im.lib.filemanage.commend.Command;
import com.xdja.im.lib.filemanage.view.FragmentVu;

public abstract class BasePresenterFragment<P extends Command, V extends FragmentVu>
extends Fragment {
    private V vu;

    public V getVu() {
        return this.vu;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        try {
            this.preBindView(savedInstanceState);
            if (this.getVuClass() != null) {
                this.vu = (FragmentVu)this.getVuClass().newInstance();
                this.vu.setCommand(this.getCommand());
                this.vu.setFragment((BasePresenterFragment)this);
                this.vu.setActivity((FragmentActivity)this.getActivity());
                this.vu.init(inflater, null);
                this.vu.onCreated();
                return this.vu.getView();
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.onBindView(savedInstanceState);
    }

    public void onPause() {
        super.onPause();
        if (this.vu != null) {
            this.vu.onPause();
        }
    }

    public void onResume() {
        super.onResume();
        if (this.vu != null) {
            this.vu.onResume();
        }
    }

    public void onStart() {
        super.onStart();
        if (this.vu != null) {
            this.vu.onStart();
        }
    }

    public void onStop() {
        super.onStop();
        if (this.vu != null) {
            this.vu.onStop();
        }
    }

    public void onDestroyView() {
        if (this.vu != null) {
            this.vu.onDestroyView();
        }
        super.onDestroyView();
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        if (this.vu != null) {
            this.vu.onCreateOptionsMenu(menu, inflater);
        }
        super.onCreateOptionsMenu(menu, inflater);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (this.vu != null) {
            this.vu.onOptionsItemSelected(item);
        }
        return super.onOptionsItemSelected(item);
    }

    @NonNull
    protected abstract Class<? extends V> getVuClass();

    @NonNull
    protected abstract P getCommand();

    protected void preBindView(Bundle savedInstanceState) {
    }

    protected void onBindView(Bundle savedInstanceState) {
    }
}

