/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.presenter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.Window;
import com.xdja.im.base.di.component.DaggerUserComponent;
import com.xdja.im.base.di.component.RepositoryComponent;
import com.xdja.im.base.di.component.UserComponent;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.lib.filemanage.commend.Command;
import com.xdja.im.lib.filemanage.commend.RemindNewMessage;
import com.xdja.im.lib.filemanage.error.OkException;
import com.xdja.im.lib.filemanage.error.OkHandler;
import com.xdja.im.lib.filemanage.presenter.BasePresenterActivity;
import com.xdja.im.lib.filemanage.util.ActomaContextWrapper;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.lib.filemanage.view.ActivityVu;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.notification.NotificationUtil;

public abstract class IMActivityPresenter<P extends Command, V extends ActivityVu>
extends BasePresenterActivity<P, V> {
    protected UserComponent userComponent;
    protected RemindNewMessage remindNewMessage;
    protected UserCache userCache;
    protected OkHandler<OkException> okHandler;

    @Override
    @SuppressLint(value={"InlinedApi"})
    protected void preBindView(Bundle savedInstanceState) {
        super.preBindView(savedInstanceState);
        Window window = this.getWindow();
        window.addFlags(Integer.MIN_VALUE);
        if (this.getCurrentThemeStyle() == 0) {
            window.setStatusBarColor(-16777216);
            this.setTheme(R.style.im_uikit_ImAppTheme);
        } else if (this.getCurrentThemeStyle() == 1) {
            View decor = window.getDecorView();
            int ui = decor.getSystemUiVisibility();
            if (Build.VERSION.SDK_INT >= 23) {
                ui = this.isLightStatusBar() ? (ui |= 0x2000) : (ui &= 0xFFFFDFFF);
                window.setStatusBarColor(this.getPrimaryColor());
            } else {
                ui &= 0xFFFFDFFF;
                window.setStatusBarColor(-16777216);
            }
            decor.setSystemUiVisibility(ui);
            this.setTheme(R.style.im_uikit_ImAppTheme);
        }
    }

    public int getCurrentThemeStyle() {
        return UniversalUtil.getThemeStyle((Context)this);
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(ActomaContextWrapper.wrap(newBase));
    }

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        RepositoryComponent repositoryComponent = ImUiKit.getInstance().getComponent();
        if (repositoryComponent != null) {
            this.userComponent = DaggerUserComponent.builder().repositoryComponent(repositoryComponent).build();
        }
        this.userCache = repositoryComponent.accountCache();
    }

    @Override
    public void onResume() {
        super.onResume();
        NotificationUtil.getInstance().clearPNNotification();
    }

    @Override
    protected void onPause() {
        super.onPause();
        NotificationUtil.getInstance().clearPNNotification();
    }
}

