/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import com.xdja.im.lib.filemanage.util.ActomaController;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.Locale;

public class ActomaContextWrapper {
    private static Locale toLocal = null;

    public static Locale getSystemLocal(Configuration config, boolean forDefault) {
        Locale sysLocale = Build.VERSION.SDK_INT > 23 ? ActomaContextWrapper.getSystemLocale(config, forDefault) : ActomaContextWrapper.getSystemLocaleLegacy(config, forDefault);
        return sysLocale;
    }

    public static void setSystemDefaultLoacl(Locale loacl, boolean reset) {
        if (toLocal == null || reset) {
            toLocal = loacl;
            LogUtil.d("", "20170209UniversalUtil setSystemDefaultLoacl " + loacl);
        }
    }

    public static Context wrap(Context context) {
        Configuration config = context.getResources().getConfiguration();
        Configuration baseConfig = null;
        Context baseContext = ActomaController.getApp();
        if (baseContext != null) {
            baseConfig = baseContext.getResources().getConfiguration();
            baseConfig.fontScale = 1.0f;
        }
        config.fontScale = 1.0f;
        Locale sysLocale = ActomaContextWrapper.getSystemLocal(config, false);
        ActomaContextWrapper.setSystemDefaultLoacl(sysLocale, false);
        Locale tolanguageLocal = UniversalUtil.getLanguageConfig(context);
        int buildVersion = Build.VERSION.SDK_INT;
        if (sysLocale != null && tolanguageLocal != null) {
            String toLanguage = tolanguageLocal.getLanguage();
            String systemCurrentLanguage = sysLocale.getLanguage();
            LogUtil.d("", "20170209ActomaContextWrapper buildVersion " + buildVersion + " toLanguage " + toLanguage + " currentLocal " + systemCurrentLanguage);
            if (!TextUtils.isEmpty((CharSequence)toLanguage)) {
                Locale locale = tolanguageLocal;
                if (buildVersion > 23) {
                    Locale.setDefault(locale);
                    if (baseConfig != null) {
                        ActomaContextWrapper.setSystemLocale(baseConfig, locale);
                    }
                    ActomaContextWrapper.setSystemLocale(config, locale);
                } else {
                    if (baseConfig != null) {
                        ActomaContextWrapper.setSystemLocaleLegacy(baseConfig, locale);
                    }
                    ActomaContextWrapper.setSystemLocaleLegacy(config, locale);
                }
            }
        } else {
            LogUtil.e("", "20170209ActomaContextWrapper wrap getLanguage error! sysLocale " + sysLocale + " tolanguageLocal " + tolanguageLocal);
        }
        if (buildVersion >= 17) {
            context = context.createConfigurationContext(config);
            if (baseConfig != null) {
                ActomaController.setApplicationConfigContext(baseContext.createConfigurationContext(baseConfig));
            }
        } else {
            context.getResources().updateConfiguration(config, context.getResources().getDisplayMetrics());
        }
        return context;
    }

    public static Locale getSystemLocaleLegacy(Configuration config, boolean forDefault) {
        Locale retLocale = forDefault ? Locale.getDefault() : config.locale;
        return retLocale;
    }

    @TargetApi(value=24)
    public static Locale getSystemLocale(Configuration config, boolean forDefault) {
        Locale retLocale = null;
        LogUtil.d("", "20170209 getSystemLocale VERSION_CODES.N forDefault " + forDefault + " toLocale " + toLocal);
        LocaleList localeList = config.getLocales();
        if (localeList != null) {
            int size = localeList.size();
            for (int i = 0; i < size; ++i) {
                LogUtil.d("", "20170209 getSystemLocale i " + i + " language " + config.getLocales().get(i));
            }
            if (forDefault) {
                if (toLocal != null) {
                    retLocale = toLocal;
                } else if (size > 0) {
                    retLocale = localeList.get(size - 1);
                }
            } else if (size > 0) {
                retLocale = localeList.get(0);
            }
        }
        LogUtil.d("", "20170209 getSystemLocale VERSION_CODES.N retLocale " + retLocale);
        return retLocale;
    }

    public static void setSystemLocaleLegacy(Configuration config, Locale locale) {
        config.locale = locale;
    }

    @TargetApi(value=24)
    public static void setSystemLocale(Configuration config, Locale locale) {
        config.setLocale(locale);
    }
}

