/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.util;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.DrawableRes;
import android.support.v4.util.LruCache;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.xdja.im.lib.filemanage.util.ActomaController;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import rx.Observable;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class ImageLoader {
    private static final String TAG = "ImageLoader";
    private static final String IMAGE_CACHE_DIR = "image_manager_disk_cache";
    private static final int THREAD_COUNT = 2;
    private LruCache<String, Bitmap> mLruCache;
    private ExecutorService mThreadPool;
    private LinkedList<Runnable> mTasks;
    private Thread mPoolThread;
    private Handler mPoolThreadHandler;
    private volatile Semaphore mSemaphore = new Semaphore(0);
    private volatile Semaphore mPoolSemaphore;
    private static ImageLoader mInstance;
    private File mRootDirectory;

    private ImageLoader(int threadCount) {
        this.init(threadCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageLoader getInstance() {
        if (mInstance != null) return mInstance;
        Class<ImageLoader> clazz = ImageLoader.class;
        synchronized (ImageLoader.class) {
            if (mInstance != null) return mInstance;
            mInstance = new ImageLoader(2);
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private void init(int threadCount) {
        this.mPoolThread = new Thread("ActomaCommon_ImageLoader"){

            @Override
            @SuppressLint(value={"HandlerLeak"})
            public void run() {
                Looper.prepare();
                ImageLoader.this.mPoolThreadHandler = new Handler(){

                    public void handleMessage(Message msg) {
                        Runnable task = ImageLoader.this.getTask();
                        if (task != null) {
                            ImageLoader.this.mThreadPool.execute(task);
                        }
                        try {
                            ImageLoader.this.mPoolSemaphore.acquire();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                };
                ImageLoader.this.mSemaphore.release();
                Looper.loop();
            }
        };
        this.mPoolThread.start();
        int maxMemory = (int)Runtime.getRuntime().maxMemory();
        int cacheSize = maxMemory / 8;
        this.mLruCache = new LruCache<String, Bitmap>(cacheSize){

            protected int sizeOf(String key, Bitmap value) {
                return value.getRowBytes() * value.getHeight();
            }
        };
        this.mRootDirectory = new File(ActomaController.getApp().getCacheDir(), IMAGE_CACHE_DIR);
        this.mThreadPool = Executors.newFixedThreadPool(threadCount);
        this.mPoolSemaphore = new Semaphore(threadCount);
        this.mTasks = new LinkedList();
    }

    public static void clearCacheWithCheck() {
        if (mInstance != null) {
            mInstance.clearCache();
        }
    }

    private void clearCache() {
        this.clearLruCache();
        if (this.mPoolThreadHandler != null && this.mPoolThreadHandler.getLooper() != null) {
            this.mPoolThreadHandler.getLooper().quit();
        } else {
            LogUtil.e(TAG, "clearCache not quit, mPoolThreadHandler " + this.mPoolThreadHandler);
        }
        this.mThreadPool.shutdown();
        mInstance = null;
    }

    public Builder crateBuilder() {
        return new Builder();
    }

    private void loadImage(String path, ImageView imageView, int maxWidth, int maxHeight, int errorResId, int defaultResId, ImageView.ScaleType scaleType, int color2) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            imageView.setImageResource(errorResId);
            return;
        }
        imageView.setTag((Object)path);
        Bitmap bm = this.getBitmapFromLruCache(this.getCacheKey(path, maxWidth, maxHeight));
        if (bm != null) {
            this.setImageBitmap(imageView, path, bm, scaleType);
        } else {
            Bitmap cachedBitmap = this.getBitmapFromDiskCache(path, maxWidth, maxHeight);
            if (cachedBitmap != null) {
                this.addBitmapToLruCache(this.getCacheKey(path, maxWidth, maxHeight), cachedBitmap);
                this.setImageBitmap(imageView, path, cachedBitmap, scaleType);
                return;
            }
            if (defaultResId > 0) {
                imageView.setImageResource(defaultResId);
            } else {
                imageView.setImageBitmap(null);
                if (color2 != -1) {
                    imageView.setBackgroundColor(color2);
                }
            }
            this.makeImageThumbnail(path, imageView, maxWidth, maxHeight, scaleType);
        }
    }

    private void loadImage(String path, ImageView imageView, int maxWidth, int maxHeight, int errorResId, int defaultResId, ImageView.ScaleType scaleType) {
        this.loadImage(path, imageView, maxWidth, maxHeight, errorResId, defaultResId, scaleType, -1);
    }

    private void makeImageThumbnail(String path, ImageView imageView, int maxWidth, int maxHeight, ImageView.ScaleType scaleType) {
        TaskRunnable runnable = new TaskRunnable(path, imageView, maxWidth, maxHeight);
        runnable.setScaleType(scaleType);
        this.addTask(runnable);
    }

    private void setImageBitmap(final ImageView imageView, final String path, final Bitmap bitmap, final ImageView.ScaleType scaleType) {
        Observable.just((Object)path).observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<String>(){

            public void call(String s) {
                if (imageView.getTag().toString().equals(path)) {
                    imageView.setScaleType(scaleType);
                    imageView.setImageBitmap(bitmap);
                }
            }
        });
    }

    private synchronized void addTask(Runnable runnable) {
        try {
            if (this.mPoolThreadHandler == null) {
                this.mSemaphore.acquire();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.mTasks.contains(runnable)) {
            this.mTasks.remove(runnable);
        }
        this.mTasks.addFirst(runnable);
        this.mPoolThreadHandler.sendEmptyMessage(272);
    }

    private synchronized Runnable getTask() {
        if (this.mTasks.size() > 0) {
            return this.mTasks.removeFirst();
        }
        return null;
    }

    private Bitmap getBitmapFromLruCache(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        return (Bitmap)this.mLruCache.get((Object)key);
    }

    private void addBitmapToLruCache(String key, Bitmap bitmap) {
        if (this.getBitmapFromLruCache(key) == null && bitmap != null) {
            this.mLruCache.put((Object)key, (Object)bitmap);
        }
    }

    private void clearLruCache() {
        if (this.mLruCache != null) {
            this.mLruCache.evictAll();
        }
        if (this.mTasks != null) {
            this.mTasks.clear();
        }
    }

    private Bitmap getBitmapFromDiskCache(String key, int maxWidth, int maxHeight) {
        try {
            File file = this.getFileForKey(key, maxWidth, maxHeight);
            return BitmapFactory.decodeFile((String)file.getAbsolutePath());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return null;
        }
    }

    private void putBitmapToDiskCache(String key, final Bitmap bitmap, final int maxWidth, final int maxHeight) {
        Observable.just((Object)key).subscribeOn(Schedulers.io()).flatMap((Func1)new Func1<String, Observable<Boolean>>(){

            public Observable<Boolean> call(String path) {
                File saveFile = ImageLoader.this.getFileForKey(path, maxWidth, maxHeight);
                return Observable.just((Object)ImageLoader.this.saveBitmap(saveFile, bitmap));
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<Boolean>(){

            public void call(Boolean aBoolean) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveBitmap(File saveFile, Bitmap bitmap) {
        if (saveFile == null || bitmap == null) {
            return false;
        }
        if (!saveFile.getParentFile().exists()) {
            saveFile.getParentFile().mkdirs();
        }
        FilterOutputStream bos = null;
        boolean bSaveRet = false;
        try {
            saveFile.createNewFile();
            bos = new BufferedOutputStream(new FileOutputStream(saveFile));
            bSaveRet = bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
            ((BufferedOutputStream)bos).flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bSaveRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap createBitmap(int degree, Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        Bitmap rotateBitmap = null;
        try {
            Matrix matrix = new Matrix();
            matrix.postRotate((float)degree);
            Bitmap bitmap2 = rotateBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            return bitmap2;
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
        finally {
            if (!bitmap.equals(rotateBitmap)) {
                bitmap.recycle();
            }
        }
        return null;
    }

    private static int getDegree(String filePath) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(filePath);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }

    private File getFileForKey(String key, int maxWidth, int maxHeight) {
        return new File(this.mRootDirectory, this.getCacheKey(key, maxWidth, maxHeight));
    }

    private String getCacheKey(String path, int maxWidth, int maxHeight) {
        File file = new File(path);
        String cacheKey = new StringBuffer().append(path).append("#").append(maxWidth).append("#").append(maxHeight).append("#").append("#").append(file.lastModified()).toString();
        return Base64.encodeToString((byte[])cacheKey.getBytes(), (int)0);
    }

    public ImageSize getImageViewWidth(ImageView imageView) {
        int height;
        int width;
        ImageSize imageSize = new ImageSize();
        DisplayMetrics displayMetrics = imageView.getContext().getResources().getDisplayMetrics();
        ViewGroup.LayoutParams params = imageView.getLayoutParams();
        int n = width = params.width == -2 ? 0 : imageView.getWidth();
        if (width <= 0) {
            width = params.width;
        }
        if (width <= 0) {
            width = ImageLoader.getImageViewFieldValue(imageView, "mMaxWidth");
        }
        if (width <= 0) {
            width = displayMetrics.widthPixels;
        }
        int n2 = height = params.height == -2 ? 0 : imageView.getHeight();
        if (height <= 0) {
            height = params.height;
        }
        if (height <= 0) {
            height = ImageLoader.getImageViewFieldValue(imageView, "mMaxHeight");
        }
        if (height <= 0) {
            height = displayMetrics.heightPixels;
        }
        imageSize.setWidth(width);
        imageSize.setHeight(height);
        return imageSize;
    }

    private int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int width = options.outWidth;
        int height = options.outHeight;
        int inSampleSize = 1;
        if (width > reqWidth && height > reqHeight) {
            int widthRatio = Math.round((float)width / (float)reqWidth);
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = Math.max(widthRatio, heightRatio);
        }
        return inSampleSize;
    }

    private Bitmap decodeSampledBitmapFromResource(String pathName, int reqWidth, int reqHeight) {
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
            options.inSampleSize = this.calculateInSampleSize(options, reqWidth, reqHeight);
            options.inJustDecodeBounds = false;
            return ImageLoader.createBitmap(ImageLoader.getDegree(pathName), BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options));
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            return null;
        }
    }

    private static int getImageViewFieldValue(Object object, String fieldName) {
        int value = 0;
        try {
            Field field = ImageView.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            int fieldValue = (Integer)field.get(object);
            if (fieldValue > 0 && fieldValue < Integer.MAX_VALUE) {
                value = fieldValue;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public class TaskRunnable
    implements Runnable {
        private String filePath;
        private ImageView targetImg;
        private int maxWidth;
        private int maxHeight;
        private ImageView.ScaleType scaleType;

        public TaskRunnable(String filePath, ImageView targetImg) {
            this.filePath = filePath;
            this.targetImg = targetImg;
        }

        public TaskRunnable(String filePath, ImageView targetImg, int maxWidth, int maxHeight) {
            this.filePath = filePath;
            this.targetImg = targetImg;
            this.maxWidth = maxWidth;
            this.maxHeight = maxHeight;
        }

        @Override
        public void run() {
            int reqWidth = this.maxWidth;
            int reqHeight = this.maxHeight;
            if (reqWidth == 0 || reqHeight == 0) {
                ImageSize imageSize = ImageLoader.this.getImageViewWidth(this.targetImg);
                reqWidth = imageSize.getWidth();
                reqHeight = imageSize.getHeight();
            }
            Bitmap bm = ImageLoader.this.decodeSampledBitmapFromResource(this.filePath, reqWidth, reqHeight);
            ImageLoader.this.addBitmapToLruCache(ImageLoader.this.getCacheKey(this.filePath, this.maxWidth, this.maxHeight), bm);
            ImageLoader.this.putBitmapToDiskCache(this.filePath, bm, reqWidth, reqHeight);
            ImageLoader.this.setImageBitmap(this.targetImg, this.filePath, bm, this.scaleType);
            ImageLoader.this.mPoolSemaphore.release();
        }

        public String getFilePath() {
            return this.filePath;
        }

        public void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public ImageView getTargetImg() {
            return this.targetImg;
        }

        public void setTargetImg(ImageView targetImg) {
            this.targetImg = targetImg;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public void setMaxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
        }

        public int getMaxHeight() {
            return this.maxHeight;
        }

        public void setMaxHeight(int maxHeight) {
            this.maxHeight = maxHeight;
        }

        public ImageView.ScaleType getScaleType() {
            return this.scaleType;
        }

        public void setScaleType(ImageView.ScaleType scaleType) {
            this.scaleType = scaleType;
        }

        public String toString() {
            return "TaskRunnable{filePath='" + this.filePath + '\'' + ", maxWidth=" + this.maxWidth + ", maxHeight=" + this.maxHeight + ", scaleType=" + this.scaleType + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskRunnable that = (TaskRunnable)o;
            if (this.maxWidth != that.maxWidth) {
                return false;
            }
            if (this.maxHeight != that.maxHeight) {
                return false;
            }
            if (!this.filePath.equals(that.filePath)) {
                return false;
            }
            return this.scaleType == that.scaleType;
        }

        public int hashCode() {
            int result = this.filePath.hashCode();
            result = 31 * result + this.maxWidth;
            result = 31 * result + this.maxHeight;
            result = 31 * result + (this.scaleType != null ? this.scaleType.hashCode() : 0);
            return result;
        }
    }

    public class ImageSize {
        private int width;
        private int height;

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }
    }

    public class Builder {
        private String filePath;
        private int maxWidth;
        private int maxHeight;
        @DrawableRes
        private int errorResId;
        @DrawableRes
        private int defaultResId;
        private ImageView.ScaleType scaleType = ImageView.ScaleType.FIT_CENTER;
        private ImageView target;

        public Builder load(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder preLoad(int maxWidth, int maxHeight) {
            this.maxWidth = maxWidth;
            this.maxHeight = maxHeight;
            return this;
        }

        public Builder error(@DrawableRes int errorResId) {
            this.errorResId = errorResId;
            return this;
        }

        public Builder placeholder(@DrawableRes int defaultResId) {
            this.defaultResId = defaultResId;
            return this;
        }

        public Builder fitCenter() {
            this.scaleType = ImageView.ScaleType.FIT_CENTER;
            return this;
        }

        public Builder centerCrop() {
            this.scaleType = ImageView.ScaleType.CENTER_CROP;
            return this;
        }

        public Builder centerInside() {
            this.scaleType = ImageView.ScaleType.CENTER_INSIDE;
            return this;
        }

        public Builder into(ImageView target) {
            this.target = target;
            return this;
        }

        public void build() {
            ImageLoader.this.loadImage(this.filePath, this.target, this.maxWidth, this.maxHeight, this.errorResId, this.defaultResId, this.scaleType);
        }

        public void build(int color2) {
            ImageLoader.this.loadImage(this.filePath, this.target, this.maxWidth, this.maxHeight, this.errorResId, this.defaultResId, this.scaleType, color2);
        }
    }
}

