/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.commend.IHistoryFileListAdapterCommand;
import com.xdja.im.lib.filemanage.util.DateUtils;
import com.xdja.im.lib.filemanage.util.FileInfoCollection;
import com.xdja.im.lib.filemanage.util.HistoryFileUtils;
import com.xdja.im.lib.filemanage.util.NetworkHelper;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.lib.filemanage.view.AdapterSuperView;
import com.xdja.im.lib.filemanage.view.AdapterVu;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.log.LogUtil;

public class ViewLastFileContent
extends AdapterSuperView<IHistoryFileListAdapterCommand, TalkMessageBean>
implements AdapterVu<IHistoryFileListAdapterCommand, TalkMessageBean> {
    private TextView mFileNameTv;
    private ImageView mFileIconIv;
    private TextView mFileSizeTv;
    private TextView mFileDateTv;
    private CheckBox mFileSelectCb;
    private TextView mFileDownloadBtn;
    private ProgressBar mFileDownloadPb;
    private LinearLayout mParentLayout;
    private TextView mFileOutDateTv;
    private TextView mFileFromTv;
    private LinearLayout mFileDateLayout;
    private long lastTime;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_history_filelist_item;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = this.getView();
        if (view != null) {
            this.mParentLayout = (LinearLayout)view.findViewById(R.id.history_file_content_layout);
            this.mFileNameTv = (TextView)view.findViewById(R.id.tv_file_title);
            this.mFileIconIv = (ImageView)view.findViewById(R.id.img_file_icon);
            this.mFileSizeTv = (TextView)view.findViewById(R.id.tv_file_desc);
            this.mFileDateTv = (TextView)view.findViewById(R.id.tv_file_date);
            this.mFileSelectCb = (CheckBox)view.findViewById(R.id.history_file_select);
            this.mFileDownloadBtn = (TextView)view.findViewById(R.id.history_file_op);
            this.mFileDownloadPb = (ProgressBar)view.findViewById(R.id.pb_file_download);
            this.mFileOutDateTv = (TextView)view.findViewById(R.id.tv_file_out_date);
            this.mFileFromTv = (TextView)view.findViewById(R.id.tv_file_from);
            this.mFileDateLayout = (LinearLayout)view.findViewById(R.id.layout_history_date_from);
        }
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        this.initView(position);
    }

    private void initView(final int groupPosition) {
        if (this.dataSource != null) {
            FileInfo fileInfo = ((TalkMessageBean)this.dataSource).getFileInfo();
            int resId = HistoryFileUtils.getIconWithSuffix((TalkMessageBean)this.dataSource);
            this.mFileIconIv.setImageResource(resId);
            this.mFileNameTv.setText((CharSequence)fileInfo.getFileName());
            this.mFileSizeTv.setText((CharSequence)FileSizeUtils.FormetFileSize(fileInfo.getFileSize()));
            this.mFileDateTv.setText((CharSequence)DateUtils.displayShowTime((Context)this.getActivity(), ((TalkMessageBean)this.dataSource).getShowTime()));
            this.mFileOutDateTv.setText((CharSequence)String.format(this.getStringRes(R.string.im_uikit_history_file_outdate), DateUtils.stringOfOverdue((Context)this.getActivity(), ((TalkMessageBean)this.dataSource).getShowTime())));
            this.mFileSelectCb.setVisibility(0);
            this.mFileDownloadBtn.setVisibility(8);
            this.mFileDownloadPb.setVisibility(8);
            this.clickBtnState(((TalkMessageBean)this.dataSource).getFileInfo().getFileState());
            this.mFileDownloadBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    long currentTime = SystemClock.elapsedRealtime();
                    if (currentTime - ViewLastFileContent.this.lastTime < 500L) {
                        return;
                    }
                    ViewLastFileContent.this.lastTime = currentTime;
                    FileInfo fInfo = ((TalkMessageBean)ViewLastFileContent.this.dataSource).getFileInfo();
                    int fileState = fInfo.getFileState();
                    if (NetworkHelper.getHelper().networkUseless() && (fileState == 4 || fileState == 1)) {
                        Toast.makeText((Context)ViewLastFileContent.this.getActivity(), (CharSequence)ViewLastFileContent.this.getStringRes(R.string.im_uikit_network_disabled), (int)0).show();
                        return;
                    }
                    if (ViewLastFileContent.this.updateFileState(fInfo, fileState) == -1) {
                        return;
                    }
                    ViewLastFileContent.this.clickBtnState(((TalkMessageBean)ViewLastFileContent.this.dataSource).getFileInfo().getFileState());
                    ((IHistoryFileListAdapterCommand)ViewLastFileContent.this.getCommand()).clickToDownloadOfOpen((TalkMessageBean)ViewLastFileContent.this.dataSource);
                }
            });
            this.mFileSelectCb.setChecked(((TalkMessageBean)this.dataSource).isChecked());
            this.mFileSelectCb.setClickable(false);
            this.mFileSelectCb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    ((TalkMessageBean)ViewLastFileContent.this.dataSource).setChecked(isChecked);
                    FileInfo fileInfo = ((TalkMessageBean)ViewLastFileContent.this.dataSource).getFileInfo();
                    FileItem localFileInfo = new FileItem(fileInfo.getFileName(), fileInfo.getFilePath(), fileInfo.getFileSize(), 0L, fileInfo.getFileType());
                    if (isChecked) {
                        FileInfoCollection.getInstance().putFileToSelectedCache(fileInfo.getFilePath() + ((TalkMessageBean)ViewLastFileContent.this.dataSource).getId(), localFileInfo);
                    } else {
                        FileInfoCollection.getInstance().removeToSelectedCache(fileInfo.getFilePath() + ((TalkMessageBean)ViewLastFileContent.this.dataSource).getId());
                    }
                    ((IHistoryFileListAdapterCommand)ViewLastFileContent.this.getCommand()).toRefreshSelectHint(localFileInfo);
                }
            });
            this.mParentLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    v.setTag(R.id.history_file_select, (Object)ViewLastFileContent.this.mFileSelectCb);
                    ((IHistoryFileListAdapterCommand)ViewLastFileContent.this.getCommand()).onClickItem(v, groupPosition, (TalkMessageBean)ViewLastFileContent.this.dataSource);
                }
            });
            this.setSenderName();
        }
    }

    private int updateFileState(FileInfo fInfo, int fileState) {
        switch (fileState) {
            case 1: {
                if (((TalkMessageBean)this.dataSource).getMessageState() == 7) {
                    new XToast((Context)this.getActivity()).display(R.string.im_uikit_history_file_recall);
                    return -1;
                }
                fInfo.setFileState(3);
                break;
            }
            case 3: {
                fInfo.setFileState(4);
                break;
            }
            case 4: {
                if (((TalkMessageBean)this.dataSource).getMessageState() == 7) {
                    new XToast((Context)this.getActivity()).display(R.string.im_uikit_history_file_recall);
                    return -1;
                }
                fInfo.setFileState(3);
                break;
            }
            case 5: {
                fInfo.setFileState(3);
            }
        }
        return 0;
    }

    private boolean isOpen() {
        FileInfo fileInfo = ((TalkMessageBean)this.dataSource).getFileInfo();
        return HistoryFileUtils.isFileExist(fileInfo.getFilePath());
    }

    private void clickBtnState(int state) {
        Drawable btnDrawable = null;
        if (((TalkMessageBean)this.dataSource).isMine()) {
            this.mFileDateLayout.setVisibility(0);
            this.mFileOutDateTv.setVisibility(8);
            this.mFileFromTv.setVisibility(0);
            this.mFileDownloadPb.setVisibility(8);
            btnDrawable = this.getDrawableRes(UniversalUtil.getThemeStyle(this.getContext()) == 0 ? R.drawable.im_uikit_history_lookup : R.drawable.im_uikit_history_lookup_light);
        } else if (DateUtils.isOverdue(((TalkMessageBean)this.dataSource).getShowTime())) {
            this.mFileDateLayout.setVisibility(0);
            this.mFileOutDateTv.setVisibility(8);
            this.mFileDownloadPb.setVisibility(8);
            if (this.isOpen()) {
                btnDrawable = this.getDrawableRes(UniversalUtil.getThemeStyle(this.getContext()) == 0 ? R.drawable.im_uikit_history_lookup : R.drawable.im_uikit_history_lookup_light);
            } else {
                btnDrawable = this.getDrawableRes(UniversalUtil.getThemeStyle(this.getContext()) == 0 ? R.drawable.im_uikit_history_download : R.drawable.im_uikit_history_download_light);
                this.mFileDownloadBtn.setEnabled(false);
            }
        } else {
            LogUtil.d("", "zhu->UI Content:progress=" + ((TalkMessageBean)this.dataSource).getFileInfo().getTranslatePercent() + ",state=" + state);
            this.mFileDownloadBtn.setEnabled(true);
            switch (state) {
                case 1: {
                    btnDrawable = this.getDrawableRes(UniversalUtil.getThemeStyle(this.getContext()) == 0 ? R.drawable.im_uikit_history_download : R.drawable.im_uikit_history_download_light);
                    this.mFileDateLayout.setVisibility(0);
                    this.mFileDownloadPb.setVisibility(8);
                    this.mFileOutDateTv.setVisibility(0);
                    break;
                }
                case 3: {
                    btnDrawable = this.getDrawableRes(UniversalUtil.getThemeStyle(this.getContext()) == 0 ? R.drawable.im_uikit_history_pause : R.drawable.im_uikit_history_pause_light);
                    this.mFileDateLayout.setVisibility(8);
                    this.mFileDownloadPb.setVisibility(0);
                    this.mFileOutDateTv.setVisibility(0);
                    break;
                }
                case 2: {
                    btnDrawable = this.getDrawableRes(UniversalUtil.getThemeStyle(this.getContext()) == 0 ? R.drawable.im_uikit_history_lookup : R.drawable.im_uikit_history_lookup_light);
                    this.mFileDateLayout.setVisibility(0);
                    this.mFileDownloadPb.setVisibility(8);
                    this.mFileOutDateTv.setVisibility(8);
                    break;
                }
                case 4: {
                    btnDrawable = this.getDrawableRes(UniversalUtil.getThemeStyle(this.getContext()) == 0 ? R.drawable.im_uikit_history_resume : R.drawable.im_uikit_history_resume_light);
                    this.mFileDateLayout.setVisibility(8);
                    this.mFileDownloadPb.setVisibility(0);
                    this.mFileOutDateTv.setVisibility(0);
                    break;
                }
                case 5: {
                    btnDrawable = this.getDrawableRes(UniversalUtil.getThemeStyle(this.getContext()) == 0 ? R.drawable.im_uikit_history_download : R.drawable.im_uikit_history_download_light);
                    this.mFileDateLayout.setVisibility(0);
                    this.mFileDownloadPb.setVisibility(8);
                    this.mFileOutDateTv.setVisibility(0);
                }
            }
        }
        this.mFileDownloadBtn.setBackground(btnDrawable);
        this.mFileDownloadPb.setProgress(((TalkMessageBean)this.dataSource).getFileInfo().getTranslatePercent());
    }

    private void setSenderName() {
        String senderName;
        if (((TalkMessageBean)this.dataSource).isGroupMsg()) {
            senderName = String.format(this.getStringRes(R.string.im_uikit_history_file_come_from), this.getStringRes(R.string.im_uikit_group_chat));
        } else {
            AccountBean info = ((IHistoryFileListAdapterCommand)this.getCommand()).getAccountBean(((TalkMessageBean)this.dataSource).isMine() ? ((TalkMessageBean)this.dataSource).getTo() : ((TalkMessageBean)this.dataSource).getFrom());
            senderName = String.format(this.getStringRes(((TalkMessageBean)this.dataSource).isMine() ? R.string.im_uikit_history_file_come_to : R.string.im_uikit_history_file_come_from), info.getDisplayName());
        }
        this.mFileFromTv.setText((CharSequence)senderName);
    }
}

