/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.historyfile.view;

import android.content.SharedPreferences;
import android.graphics.Color;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.lib.file.widget.ViewPagerIndicator;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.lib.filemanage.view.ImpActivitySuperView;
import com.xdja.im.lib.historyfile.command.IHistoryFileActivityPresenterCommand;
import com.xdja.im.lib.historyfile.util.HistoryModeUtils;
import com.xdja.im.lib.historyfile.vu.IHistoryFileActivityPresenterVu;
import com.xdja.im.uikit.R;

public class ViewHistoryFileActivityPresenter
extends ImpActivitySuperView<IHistoryFileActivityPresenterCommand>
implements IHistoryFileActivityPresenterVu,
View.OnClickListener {
    private Toolbar toolbar;
    private ViewPager viewPager;
    private ViewPagerIndicator vpIndicator;
    private TextView mSelectCancel;
    private TextView mSelectTitle;
    private TextView mSelectFileSize;
    private TextView mOperateAction;
    private RelativeLayout mToolbarLayout;
    private LinearLayout mOperationLayout;
    private RelativeLayout mOperateActionLayout;
    private LinearLayout mDownloadLayout;
    private LinearLayout mTransmitLayout;
    private LinearLayout mDeleteLayout;
    private int style = 0;
    private int mCurrentOperate;
    private SharedPreferences sharedPreferences;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_activity_history_all_files;
    }

    @Override
    protected int getToolbarType() {
        return 0;
    }

    @Override
    public int getToolbarTitle() {
        return R.string.im_uikit_chat_file_history_list;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = this.getView();
        this.style = UniversalUtil.getThemeStyle(this.getContext());
        if (view != null) {
            this.toolbar = (Toolbar)view.findViewById(R.id.toolbar);
            this.mSelectCancel = (TextView)view.findViewById(R.id.select_cancel_action);
            this.mSelectTitle = (TextView)view.findViewById(R.id.history_file_selected_title);
            this.viewPager = (ViewPager)view.findViewById(R.id.history_file_vp);
            this.vpIndicator = (ViewPagerIndicator)view.findViewById(R.id.history_file_indicator);
            this.mToolbarLayout = (RelativeLayout)view.findViewById(R.id.toolbar_layout);
            this.mOperationLayout = (LinearLayout)view.findViewById(R.id.file_operation_layout);
            this.mDownloadLayout = (LinearLayout)view.findViewById(R.id.btn_history_file_download_layout);
            this.mTransmitLayout = (LinearLayout)view.findViewById(R.id.btn_history_file_resend_layout);
            this.mDeleteLayout = (LinearLayout)view.findViewById(R.id.btn_history_file_remove_layout);
            this.mOperateActionLayout = (RelativeLayout)view.findViewById(R.id.operate_action_layout);
            this.mSelectFileSize = (TextView)view.findViewById(R.id.operate_file_size);
            this.mOperateAction = (TextView)view.findViewById(R.id.operate_action);
        }
    }

    @Override
    public void init(LayoutInflater inflater, ViewGroup container) {
        super.init(inflater, container);
        this.addListeners();
        this.mSelectCancel.setTextColor(this.style == 0 ? Color.parseColor((String)"#AE9153") : Color.parseColor((String)"#00BD71"));
        this.mSelectTitle.setTextColor(this.style == 0 ? Color.parseColor((String)"#CCB481") : Color.parseColor((String)"#F3000000"));
        this.sharedPreferences = this.getActivity().getSharedPreferences("PageTabPositionRecord", 0);
    }

    private void addListeners() {
        this.mSelectCancel.setOnClickListener((View.OnClickListener)this);
        this.mDownloadLayout.setOnClickListener((View.OnClickListener)this);
        this.mTransmitLayout.setOnClickListener((View.OnClickListener)this);
        this.mDeleteLayout.setOnClickListener((View.OnClickListener)this);
        this.mOperateAction.setOnClickListener((View.OnClickListener)this);
    }

    @Override
    public void setFragmentAdapter(FragmentPagerAdapter adapter) {
        this.viewPager.setOffscreenPageLimit(adapter.getCount());
        this.viewPager.setAdapter((PagerAdapter)adapter);
        this.viewPager.setCurrentItem(this.sharedPreferences.getInt("history_file_page_position", 0));
        this.vpIndicator.setViewPager(this.viewPager);
    }

    @Override
    public void onDestroy() {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        editor.putInt("history_file_page_position", this.viewPager.getCurrentItem());
        editor.apply();
        super.onDestroy();
    }

    @Override
    public void showEmpty(boolean isShowEmpty) {
    }

    @Override
    public void refreshSelectHint(int num) {
        if (num == 0) {
            HistoryModeUtils.getInstance().clearCache();
        }
        if (this.mCurrentOperate != 0) {
            String title = this.getStringRes(R.string.im_uikit_history_file_select_hint);
            long size = HistoryModeUtils.getInstance().getSelectRawFileSize();
            this.mSelectFileSize.setText((CharSequence)String.format(title, FileSizeUtils.FormetFileSize(size)));
            if (this.mCurrentOperate == 1) {
                this.mOperateAction.setText((CharSequence)(this.getStringRes(R.string.im_uikit_chat_file_history_list_download) + "(" + num + ")"));
            } else if (this.mCurrentOperate == 2) {
                this.mOperateAction.setText((CharSequence)(this.getStringRes(R.string.im_uikit_chat_file_history_list_resend) + "(" + num + ")"));
            } else if (this.mCurrentOperate == 3) {
                this.mOperateAction.setText((CharSequence)(this.getStringRes(R.string.im_uikit_chat_file_history_list_remove) + "(" + num + ")"));
            }
        }
    }

    @Override
    public void refreshUI() {
        if (this.mCurrentOperate != 0) {
            this.toolbar.setVisibility(4);
            this.mSelectCancel.setVisibility(0);
            this.mSelectTitle.setVisibility(0);
            this.mOperationLayout.setVisibility(8);
            this.mOperateActionLayout.setVisibility(0);
        } else {
            this.mSelectCancel.setVisibility(8);
            this.mSelectTitle.setVisibility(8);
            this.toolbar.setVisibility(0);
            this.toolbar.setTitle(R.string.im_uikit_chat_file_history_list);
            this.mOperationLayout.setVisibility(0);
            this.mOperateActionLayout.setVisibility(8);
        }
        this.refreshSelectHint(0);
        ((IHistoryFileActivityPresenterCommand)this.getCommand()).updateMode(this.mCurrentOperate);
    }

    @Override
    public void setOperateAction(int operateAction) {
        this.mCurrentOperate = operateAction;
    }

    public void onClick(View v) {
        if (((IHistoryFileActivityPresenterCommand)this.getCommand()).isRefreshing()) {
            return;
        }
        if (v.getId() == R.id.select_cancel_action) {
            this.mCurrentOperate = 0;
            this.refreshUI();
            ((IHistoryFileActivityPresenterCommand)this.getCommand()).obtainDataMap();
        } else if (v.getId() == R.id.btn_history_file_download_layout) {
            this.mCurrentOperate = 1;
            this.refreshUI();
        } else if (v.getId() == R.id.btn_history_file_resend_layout) {
            this.mCurrentOperate = 2;
            this.refreshUI();
        } else if (v.getId() == R.id.btn_history_file_remove_layout) {
            this.mCurrentOperate = 3;
            this.refreshUI();
        } else if (v.getId() == R.id.operate_action) {
            if (this.mCurrentOperate == 1) {
                ((IHistoryFileActivityPresenterCommand)this.getCommand()).downloadFiles();
            } else if (this.mCurrentOperate == 2) {
                ((IHistoryFileActivityPresenterCommand)this.getCommand()).transmitFiles();
            } else if (this.mCurrentOperate == 3) {
                ((IHistoryFileActivityPresenterCommand)this.getCommand()).removeFiles();
            }
        } else if (v.getId() == R.id.select_all) {
            // empty if block
        }
    }
}

