/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.historyfile.vu;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.lib.filemanage.model.GridItemBean;
import com.xdja.im.lib.filemanage.util.DateUtils;
import com.xdja.im.lib.filemanage.util.HistoryFileUtils;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.lib.historyfile.command.IHistoryPhotoAndVideoAdapterCommand;
import com.xdja.im.lib.historyfile.util.HistoryModeUtils;
import com.xdja.im.lib.historyfile.vu.ViewHistoryBaseItem;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.view.CircleProgressBar;

public class ViewHistoryPhotoItem
extends ViewHistoryBaseItem {
    private ImageView imageView;
    private CheckBox isSelected;
    private CircleProgressBar circleProgressBar;
    private TextView imageShade;
    private int style = 0;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_file_image_fragment_image;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = this.getView();
        this.style = UniversalUtil.getThemeStyle(this.getContext());
        if (view != null) {
            this.imageView = (ImageView)view.findViewById(R.id.image_file_image);
            this.isSelected = (CheckBox)view.findViewById(R.id.chx_img_file_select);
            this.circleProgressBar = (CircleProgressBar)view.findViewById(R.id.image_down_cpb);
            this.imageShade = (TextView)view.findViewById(R.id.image_file_shade);
        }
    }

    @Override
    public void bindDataSource(int position, @NonNull GridItemBean dataSource) {
        super.bindDataSource(position, dataSource);
        final TalkMessageBean dataTalk = (TalkMessageBean)dataSource.getValue();
        FileInfo fileInfo = dataTalk.getFileInfo();
        this.circleProgressBar.setMax(100);
        if (fileInfo.getFileState() == 3) {
            this.circleProgressBar.setVisibility(0);
        } else {
            this.circleProgressBar.setVisibility(8);
        }
        if (!HistoryFileUtils.isFileExist(dataTalk) && !dataTalk.isMine() && DateUtils.isOverdue(dataTalk.getShowTime())) {
            this.imageShade.setVisibility(0);
        } else {
            this.imageShade.setVisibility(8);
        }
        if (HistoryFileUtils.isSendReadReceipt(dataTalk)) {
            ((IHistoryPhotoAndVideoAdapterCommand)this.getCommand()).sendReadReceipt(dataTalk);
        }
        this.isSelected.setVisibility(dataTalk.hasFileOperate() ? 0 : 8);
        this.isSelected.setClickable(false);
        this.isSelected.setButtonDrawable(dataTalk.isChecked() ? (this.style == 0 ? R.drawable.im_uikit_icon_selected_on : R.drawable.im_uikit_icon_selected_on_light) : R.drawable.im_uikit_icon_selected_off);
        this.isSelected.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                dataTalk.setChecked(isChecked);
                ViewHistoryPhotoItem.this.isSelected.setButtonDrawable(isChecked ? (ViewHistoryPhotoItem.this.style == 0 ? R.drawable.im_uikit_icon_selected_on : R.drawable.im_uikit_icon_selected_on_light) : R.drawable.im_uikit_icon_selected_off);
                if (isChecked) {
                    HistoryModeUtils.getInstance().putFileToSelectedCache(dataTalk.getId(), dataTalk);
                } else {
                    HistoryModeUtils.getInstance().removeToSelectedCache(dataTalk.getId());
                }
                ((IHistoryPhotoAndVideoAdapterCommand)ViewHistoryPhotoItem.this.getCommand()).toRefreshSelectHint();
            }
        });
        this.isSelected.setChecked(dataTalk.isChecked());
        Glide.with((Activity)this.getActivity()).load(fileInfo.getFilePath()).placeholder(R.drawable.im_uikit_ic_jpg).into(this.imageView);
    }
}

