/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.view.ViewSessionItem;
import com.xdja.im.uikit.utils.log.LogUtil;

public class ViewSingleItem
extends ViewSessionItem {
    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_session_single;
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkSessionBean dataSource) {
        super.bindDataSource(position, dataSource);
    }

    @Override
    protected CharSequence getContent(String displayName) {
        SessionParam param = ((TalkSessionBean)this.dataSource).getParam();
        if (param != null && !TextUtils.isEmpty((CharSequence)param.getDraftContent()) && param.getDraftTime() > 0L) {
            CharSequence content = this.formatDraft(param.getDraftContent());
            LogUtil.d("ViewSingleItem draft:" + content);
            return EmotionUtils.formatSmallSpanContent(content, (Context)this.getActivity());
        }
        TalkMessageBean talkMessageBean = ((TalkSessionBean)this.dataSource).getLastMsg();
        if (talkMessageBean == null) {
            LogUtil.w("Last message info is null.");
            return "";
        }
        int messageType = talkMessageBean.getMessageType();
        if (!talkMessageBean.isMine() && talkMessageBean.isBomb() && talkMessageBean.getMessageState() == 5) {
            return this.getStringRes(R.string.im_uikit_bomb);
        }
        switch (messageType) {
            case 0: {
                return EmotionUtils.formatSmallSpanContent(((TalkSessionBean)this.dataSource).getContent(), (Context)this.getActivity());
            }
            case 1: {
                return this.getStringRes(R.string.im_uikit_voice);
            }
            case 2: {
                return this.getStringRes(R.string.im_uikit_video);
            }
            case 3: {
                return this.getStringRes(R.string.im_uikit_image);
            }
            case 4: {
                return this.getStringRes(R.string.im_uikit_file);
            }
            case 102: {
                return this.getCustomStr(talkMessageBean);
            }
        }
        return ((TalkSessionBean)this.dataSource).getContent() == null ? "" : ((TalkSessionBean)this.dataSource).getContent();
    }
}

