/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.utils;

import android.text.TextUtils;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.lib.album.bean.ImageThumbBean;
import com.xdja.im.lib.camera.bean.PhotoThumbBean;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.util.ToolUtil;
import com.xdja.im.lib.video.bean.VideoItem;
import com.xdja.im.uikit.utils.log.LogUtil;

public class DataConvertUtils {
    public static FileInfo mapImageFileInfo(ImageThumbBean thumbBean) {
        ImageFileInfo imageFileInfo = new ImageFileInfo();
        if (TextUtils.isEmpty((CharSequence)thumbBean.getThumbPath()) || TextUtils.isEmpty((CharSequence)thumbBean.getHdThumbPath())) {
            LogUtil.e("ERROR:thumb path is empty or hd thumb path is null.");
            return null;
        }
        FileInfo gifThumbFile = new FileInfo();
        gifThumbFile.setFileName(thumbBean.getThumbName());
        gifThumbFile.setFilePath(thumbBean.getThumbPath());
        gifThumbFile.setFileSize(thumbBean.getThumbSize());
        imageFileInfo.setGifFileInfo(gifThumbFile);
        FileInfo hdThumbFile = new FileInfo();
        hdThumbFile.setFileName(thumbBean.getHdThumbName());
        hdThumbFile.setFilePath(thumbBean.getHdThumbPath());
        hdThumbFile.setFileSize(thumbBean.getHdThumbSize());
        imageFileInfo.setHdFileInfo(hdThumbFile);
        if (!TextUtils.isEmpty((CharSequence)thumbBean.getRawPath())) {
            FileInfo rawFileInfo = new FileInfo();
            rawFileInfo.setFileName(thumbBean.getRawName());
            rawFileInfo.setFilePath(thumbBean.getRawPath());
            rawFileInfo.setFileSize(thumbBean.getRawSize());
            imageFileInfo.setRawFileInfo(rawFileInfo);
            imageFileInfo.setOriginal(true);
            String suffix = ToolUtil.getLastString(thumbBean.getRawPath(), ".");
            if (!TextUtils.isEmpty((CharSequence)suffix)) {
                rawFileInfo.setSuffix(suffix);
                imageFileInfo.setSuffix(suffix);
            }
            imageFileInfo.setFilePath(thumbBean.getRawPath());
            imageFileInfo.setFileName(thumbBean.getRawName());
            imageFileInfo.setFileSize(thumbBean.getRawSize());
        }
        return imageFileInfo;
    }

    public static FileInfo mapVideoFileInfo(VideoItem videoItem) {
        if (TextUtils.isEmpty((CharSequence)videoItem.getFilePath()) || TextUtils.isEmpty((CharSequence)videoItem.getRawFilePath())) {
            LogUtil.e("ERROR: video file path is null.");
            return null;
        }
        VideoFileInfo videoFileInfo = new VideoFileInfo();
        videoFileInfo.setFileName(videoItem.getFileName());
        videoFileInfo.setFilePath(videoItem.getFilePath());
        videoFileInfo.setFileSize(videoItem.getFileSize());
        FileInfo rawFileInfo = new FileInfo();
        rawFileInfo.setFileName(videoItem.getRawFileName());
        rawFileInfo.setFilePath(videoItem.getRawFilePath());
        rawFileInfo.setFileSize(videoItem.getRawFileSize());
        videoFileInfo.setRawFileInfo(rawFileInfo);
        videoFileInfo.setAmountOfTime(videoItem.getDuration());
        videoFileInfo.setRawFileSize(videoItem.getRawFileSize());
        return videoFileInfo;
    }

    public static FileInfo mapPhotoFileInfo(PhotoThumbBean thumbBean) {
        ImageFileInfo imageFileInfo = new ImageFileInfo();
        if (TextUtils.isEmpty((CharSequence)thumbBean.getThumbPath()) || TextUtils.isEmpty((CharSequence)thumbBean.getHdThumbPath())) {
            LogUtil.e("ERROR:thumb path is im_uikit_empty or hd thumb path is null.");
            return null;
        }
        imageFileInfo.setFileName(thumbBean.getThumbName());
        imageFileInfo.setFilePath(thumbBean.getThumbPath());
        imageFileInfo.setFileSize(thumbBean.getThumbSize());
        FileInfo hdThumbFile = new FileInfo();
        hdThumbFile.setFileName(thumbBean.getHdThumbName());
        hdThumbFile.setFilePath(thumbBean.getHdThumbPath());
        hdThumbFile.setFileSize(thumbBean.getHdThumbSize());
        imageFileInfo.setHdFileInfo(hdThumbFile);
        if (!TextUtils.isEmpty((CharSequence)thumbBean.getRawPath())) {
            FileInfo rawFileInfo = new FileInfo();
            rawFileInfo.setFileName(thumbBean.getRawName());
            rawFileInfo.setFilePath(thumbBean.getRawPath());
            rawFileInfo.setFileSize(thumbBean.getRawSize());
            imageFileInfo.setRawFileInfo(rawFileInfo);
            imageFileInfo.setOriginal(true);
        }
        return imageFileInfo;
    }

    public static FileInfo mapFileInfo(FileItem fileItem) {
        if (TextUtils.isEmpty((CharSequence)fileItem.getFilePath())) {
            LogUtil.e("ERROR: file path is null.");
            return null;
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFileName(fileItem.getFileName());
        fileInfo.setFilePath(fileItem.getFilePath());
        fileInfo.setFileSize(fileItem.getFileSize());
        String suffix = ToolUtil.getLastString(fileItem.getFileName(), ".");
        if (!TextUtils.isEmpty((CharSequence)suffix)) {
            fileInfo.setSuffix(suffix);
        }
        return fileInfo;
    }
}

