/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.utils.file;

import android.text.TextUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.ConvertUtils;
import com.xdja.im.uikit.utils.IoUtils;
import com.xdja.im.uikit.utils.StringUtils;
import com.xdja.im.uikit.utils.file.MimeUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FileUtils {
    private FileUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static File getFileByPath(String filePath) {
        return StringUtils.isSpace(filePath) ? null : new File(filePath);
    }

    public static boolean isFileExists(String filePath) {
        return FileUtils.isFileExists(FileUtils.getFileByPath(filePath));
    }

    public static boolean isFileExists(File file) {
        return file != null && file.exists();
    }

    public static boolean rename(String filePath, String newName) {
        return FileUtils.rename(FileUtils.getFileByPath(filePath), newName);
    }

    public static boolean rename(File file, String newName) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (StringUtils.isSpace(newName)) {
            return false;
        }
        if (newName.equals(file.getName())) {
            return true;
        }
        File newFile = new File(file.getParent() + File.separator + newName);
        return !newFile.exists() && file.renameTo(newFile);
    }

    public static boolean isDir(String dirPath) {
        return FileUtils.isDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean isDir(File file) {
        return FileUtils.isFileExists(file) && file.isDirectory();
    }

    public static boolean isFile(String filePath) {
        return FileUtils.isFile(FileUtils.getFileByPath(filePath));
    }

    public static boolean isFile(File file) {
        return FileUtils.isFileExists(file) && file.isFile();
    }

    public static boolean createOrExistsDir(String dirPath) {
        return FileUtils.createOrExistsDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    public static boolean createOrExistsFile(String filePath) {
        return FileUtils.createOrExistsFile(FileUtils.getFileByPath(filePath));
    }

    public static boolean createOrExistsFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!FileUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean createFileByDeleteOldFile(String filePath) {
        return FileUtils.createFileByDeleteOldFile(FileUtils.getFileByPath(filePath));
    }

    public static boolean createFileByDeleteOldFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists() && file.isFile() && !file.delete()) {
            return false;
        }
        if (!FileUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static boolean saveFile(File srcFile, String destPath, String fileName) {
        boolean bl;
        if (!FileUtils.isFileExists(srcFile)) {
            return false;
        }
        File dir = new File(destPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File saveFile = new File(dir, fileName);
        FileInputStream fis = null;
        BufferedOutputStream bos = null;
        try {
            int readLen;
            bos = new BufferedOutputStream(new FileOutputStream(saveFile));
            fis = new FileInputStream(srcFile);
            byte[] buffer = new byte[8192];
            while ((readLen = fis.read(buffer)) > 0) {
                bos.write(buffer, 0, readLen);
            }
            bos.flush();
            bl = true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            IoUtils.closeIO(bos);
            IoUtils.closeIO(fis);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    IoUtils.closeIO(bos);
                    IoUtils.closeIO(fis);
                    throw throwable;
                }
            }
            IoUtils.closeIO(bos);
            IoUtils.closeIO(fis);
        }
        IoUtils.closeIO(bos);
        IoUtils.closeIO(fis);
        return bl;
        return false;
    }

    private static boolean copyOrMoveDir(String srcDirPath, String destDirPath, boolean isMove) {
        return FileUtils.copyOrMoveDir(FileUtils.getFileByPath(srcDirPath), FileUtils.getFileByPath(destDirPath), isMove);
    }

    private static boolean copyOrMoveDir(File srcDir, File destDir, boolean isMove) {
        File[] files;
        if (srcDir == null || destDir == null) {
            return false;
        }
        String srcPath = srcDir.getPath() + File.separator;
        String destPath = destDir.getPath() + File.separator;
        if (destPath.contains(srcPath)) {
            return false;
        }
        if (!srcDir.exists() || !srcDir.isDirectory()) {
            return false;
        }
        if (!FileUtils.createOrExistsDir(destDir)) {
            return false;
        }
        for (File file : files = srcDir.listFiles()) {
            File oneDestFile = new File(destPath + file.getName());
            if (!(file.isFile() ? !FileUtils.copyOrMoveFile(file, oneDestFile, isMove) : file.isDirectory() && !FileUtils.copyOrMoveDir(file, oneDestFile, isMove))) continue;
            return false;
        }
        return !isMove || FileUtils.deleteDir(srcDir);
    }

    private static boolean copyOrMoveFile(String srcFilePath, String destFilePath, boolean isMove) {
        return FileUtils.copyOrMoveFile(FileUtils.getFileByPath(srcFilePath), FileUtils.getFileByPath(destFilePath), isMove);
    }

    public static boolean copyOrMoveFile(File srcFile, File destFile, boolean isMove) {
        if (srcFile == null || destFile == null) {
            return false;
        }
        if (!srcFile.exists() || !srcFile.isFile()) {
            return false;
        }
        if (destFile.exists() && destFile.isFile()) {
            return false;
        }
        if (!FileUtils.createOrExistsDir(destFile.getParentFile())) {
            return false;
        }
        try {
            return FileUtils.writeFileFromIS(destFile, (InputStream)new FileInputStream(srcFile), false) && (!isMove || FileUtils.deleteFile(srcFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean copyDir(String srcDirPath, String destDirPath) {
        return FileUtils.copyDir(FileUtils.getFileByPath(srcDirPath), FileUtils.getFileByPath(destDirPath));
    }

    public static boolean copyDir(File srcDir, File destDir) {
        return FileUtils.copyOrMoveDir(srcDir, destDir, false);
    }

    public static boolean copyFile(String srcFilePath, String destFilePath) {
        return FileUtils.copyFile(FileUtils.getFileByPath(srcFilePath), FileUtils.getFileByPath(destFilePath));
    }

    public static boolean copyFile(File srcFile, File destFile) {
        return FileUtils.copyOrMoveFile(srcFile, destFile, false);
    }

    public static boolean moveDir(String srcDirPath, String destDirPath) {
        return FileUtils.moveDir(FileUtils.getFileByPath(srcDirPath), FileUtils.getFileByPath(destDirPath));
    }

    public static boolean moveDir(File srcDir, File destDir) {
        return FileUtils.copyOrMoveDir(srcDir, destDir, true);
    }

    public static boolean moveFile(String srcFilePath, String destFilePath) {
        return FileUtils.moveFile(FileUtils.getFileByPath(srcFilePath), FileUtils.getFileByPath(destFilePath));
    }

    public static boolean moveFile(File srcFile, File destFile) {
        return FileUtils.copyOrMoveFile(srcFile, destFile, true);
    }

    public static boolean deleteDir(String dirPath) {
        return FileUtils.deleteDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean deleteDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!(file.isFile() ? !FileUtils.deleteFile(file) : file.isDirectory() && !FileUtils.deleteDir(file))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean deleteFile(String srcFilePath) {
        return FileUtils.deleteFile(FileUtils.getFileByPath(srcFilePath));
    }

    public static boolean deleteFile(File file) {
        return file != null && (!file.exists() || file.isFile() && file.delete());
    }

    public static boolean deleteFilesInDir(String dirPath) {
        return FileUtils.deleteFilesInDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean deleteFilesInDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!(file.isFile() ? !FileUtils.deleteFile(file) : file.isDirectory() && !FileUtils.deleteDir(file))) continue;
                return false;
            }
        }
        return true;
    }

    public static List<File> listFilesInDir(String dirPath, boolean isRecursive) {
        return FileUtils.listFilesInDir(FileUtils.getFileByPath(dirPath), isRecursive);
    }

    public static List<File> listFilesInDir(File dir, boolean isRecursive) {
        if (!FileUtils.isDir(dir)) {
            return null;
        }
        if (isRecursive) {
            return FileUtils.listFilesInDir(dir);
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            Collections.addAll(list, files);
        }
        return list;
    }

    public static List<File> listFilesInDir(String dirPath) {
        return FileUtils.listFilesInDir(FileUtils.getFileByPath(dirPath));
    }

    public static List<File> listFilesInDir(File dir) {
        if (!FileUtils.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                list.add(file);
                if (!file.isDirectory()) continue;
                list.addAll(FileUtils.listFilesInDir(file));
            }
        }
        return list;
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, String suffix, boolean isRecursive) {
        return FileUtils.listFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), suffix, isRecursive);
    }

    public static List<File> listFilesInDirWithFilter(File dir, String suffix, boolean isRecursive) {
        if (isRecursive) {
            return FileUtils.listFilesInDirWithFilter(dir, suffix);
        }
        if (dir == null || !FileUtils.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!file.getName().toUpperCase().endsWith(suffix.toUpperCase())) continue;
                list.add(file);
            }
        }
        return list;
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, String suffix) {
        return FileUtils.listFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), suffix);
    }

    public static List<File> listFilesInDirWithFilter(File dir, String suffix) {
        if (dir == null || !FileUtils.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (file.getName().toUpperCase().endsWith(suffix.toUpperCase())) {
                    list.add(file);
                }
                if (!file.isDirectory()) continue;
                list.addAll(FileUtils.listFilesInDirWithFilter(file, suffix));
            }
        }
        return list;
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, FilenameFilter filter, boolean isRecursive) {
        return FileUtils.listFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), filter, isRecursive);
    }

    public static List<File> listFilesInDirWithFilter(File dir, FilenameFilter filter, boolean isRecursive) {
        if (isRecursive) {
            return FileUtils.listFilesInDirWithFilter(dir, filter);
        }
        if (dir == null || !FileUtils.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!filter.accept(file.getParentFile(), file.getName())) continue;
                list.add(file);
            }
        }
        return list;
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, FilenameFilter filter) {
        return FileUtils.listFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), filter);
    }

    public static List<File> listFilesInDirWithFilter(File dir, FilenameFilter filter) {
        if (dir == null || !FileUtils.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (filter.accept(file.getParentFile(), file.getName())) {
                    list.add(file);
                }
                if (!file.isDirectory()) continue;
                list.addAll(FileUtils.listFilesInDirWithFilter(file, filter));
            }
        }
        return list;
    }

    public static List<File> searchFileInDir(String dirPath, String fileName) {
        return FileUtils.searchFileInDir(FileUtils.getFileByPath(dirPath), fileName);
    }

    public static List<File> searchFileInDir(File dir, String fileName) {
        if (dir == null || !FileUtils.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (file.getName().toUpperCase().equals(fileName.toUpperCase())) {
                    list.add(file);
                }
                if (!file.isDirectory()) continue;
                list.addAll(FileUtils.searchFileInDir(file, fileName));
            }
        }
        return list;
    }

    public static boolean writeFileFromIS(String filePath, InputStream is, boolean append) {
        return FileUtils.writeFileFromIS(FileUtils.getFileByPath(filePath), is, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromIS(File file, InputStream is, boolean append) {
        boolean bl;
        if (file == null || is == null) {
            return false;
        }
        if (!FileUtils.createOrExistsFile(file)) {
            return false;
        }
        BufferedOutputStream os = null;
        try {
            int len;
            os = new BufferedOutputStream(new FileOutputStream(file, append));
            byte[] data = new byte[1024];
            while ((len = is.read(data, 0, 1024)) != -1) {
                ((OutputStream)os).write(data, 0, len);
            }
            ((OutputStream)os).flush();
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                e.printStackTrace();
                bl2 = false;
            }
            catch (Throwable throwable) {
                IoUtils.closeIO(is, os);
                throw throwable;
            }
            IoUtils.closeIO(is, os);
            return bl2;
        }
        IoUtils.closeIO(is, os);
        return bl;
    }

    public static boolean writeFileFromString(String filePath, String content, boolean append) {
        return FileUtils.writeFileFromString(FileUtils.getFileByPath(filePath), content, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromString(File file, String content, boolean append) {
        boolean bl;
        if (file == null || content == null) {
            return false;
        }
        if (!FileUtils.createOrExistsFile(file)) {
            return false;
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(file, append));
            bw.write(content);
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                e.printStackTrace();
                bl2 = false;
            }
            catch (Throwable throwable) {
                IoUtils.closeIO(bw);
                throw throwable;
            }
            IoUtils.closeIO(bw);
            return bl2;
        }
        IoUtils.closeIO(bw);
        return bl;
    }

    public static List<String> readFile2List(String filePath, String charsetName) {
        return FileUtils.readFile2List(FileUtils.getFileByPath(filePath), charsetName);
    }

    public static List<String> readFile2List(File file, String charsetName) {
        return FileUtils.readFile2List(file, 0, Integer.MAX_VALUE, charsetName);
    }

    public static List<String> readFile2List(String filePath, int st, int end, String charsetName) {
        return FileUtils.readFile2List(FileUtils.getFileByPath(filePath), st, end, charsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile2List(File file, int st, int end, String charsetName) {
        ArrayList<String> arrayList;
        if (file == null) {
            return null;
        }
        if (st > end) {
            return null;
        }
        BufferedReader reader = null;
        try {
            String line;
            ArrayList<String> list = new ArrayList<String>();
            reader = StringUtils.isSpace(charsetName) ? new BufferedReader(new FileReader(file)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
            for (int curLine = 1; (line = reader.readLine()) != null && curLine <= end; ++curLine) {
                if (st > curLine || curLine > end) continue;
                list.add(line);
            }
            arrayList = list;
        }
        catch (IOException e) {
            List<String> list;
            try {
                e.printStackTrace();
                list = null;
            }
            catch (Throwable throwable) {
                IoUtils.closeIO(reader);
                throw throwable;
            }
            IoUtils.closeIO(reader);
            return list;
        }
        IoUtils.closeIO(reader);
        return arrayList;
    }

    public static String readFile2String(String filePath, String charsetName) {
        return FileUtils.readFile2String(FileUtils.getFileByPath(filePath), charsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile2String(File file, String charsetName) {
        String string2;
        if (file == null) {
            return null;
        }
        BufferedReader reader = null;
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            reader = StringUtils.isSpace(charsetName) ? new BufferedReader(new InputStreamReader(new FileInputStream(file))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\r\n");
            }
            string2 = sb.delete(sb.length() - 2, sb.length()).toString();
        }
        catch (IOException e) {
            String string3;
            try {
                e.printStackTrace();
                string3 = null;
            }
            catch (Throwable throwable) {
                IoUtils.closeIO(reader);
                throw throwable;
            }
            IoUtils.closeIO(reader);
            return string3;
        }
        IoUtils.closeIO(reader);
        return string2;
    }

    public static byte[] readFile2Bytes(String filePath) {
        return FileUtils.readFile2Bytes(FileUtils.getFileByPath(filePath));
    }

    public static byte[] readFile2Bytes(File file) {
        if (file == null) {
            return null;
        }
        try {
            return ConvertUtils.inputStream2Bytes(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getFileCharsetSimple(String filePath) {
        return FileUtils.getFileCharsetSimple(FileUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileCharsetSimple(File file) {
        int p = 0;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            p = (((InputStream)is).read() << 8) + ((InputStream)is).read();
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IoUtils.closeIO(is);
                throw throwable;
            }
            IoUtils.closeIO(is);
        }
        IoUtils.closeIO(is);
        switch (p) {
            case 61371: {
                return "UTF-8";
            }
            case 65534: {
                return "Unicode";
            }
            case 65279: {
                return "UTF-16BE";
            }
        }
        return "GBK";
    }

    public static int getFileLines(String filePath) {
        return FileUtils.getFileLines(FileUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFileLines(File file) {
        int count = 1;
        BufferedInputStream is = null;
        try {
            int readChars;
            is = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[1024];
            while ((readChars = ((InputStream)is).read(buffer, 0, 1024)) != -1) {
                for (int i = 0; i < readChars; ++i) {
                    if (buffer[i] != 10) continue;
                    ++count;
                }
            }
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IoUtils.closeIO(is);
                throw throwable;
            }
            IoUtils.closeIO(is);
        }
        IoUtils.closeIO(is);
        return count;
    }

    public static String getDirSize(String dirPath) {
        return FileUtils.getDirSize(FileUtils.getFileByPath(dirPath));
    }

    public static String getDirSize(File dir) {
        long len = FileUtils.getDirLength(dir);
        return len == -1L ? "" : ConvertUtils.byte2FitSize(len);
    }

    public static String getFileSize(String filePath) {
        return FileUtils.getFileSize(FileUtils.getFileByPath(filePath));
    }

    public static String getFileSize(File file) {
        long len = FileUtils.getFileLength(file);
        return len == -1L ? "" : ConvertUtils.byte2FitSize(len);
    }

    public static long getDirLength(String dirPath) {
        return FileUtils.getDirLength(FileUtils.getFileByPath(dirPath));
    }

    public static long getDirLength(File dir) {
        if (!FileUtils.isDir(dir)) {
            return -1L;
        }
        long len = 0L;
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (file.isDirectory()) {
                    len += FileUtils.getDirLength(file);
                    continue;
                }
                len += file.length();
            }
        }
        return len;
    }

    public static long getFileLength(String filePath) {
        return FileUtils.getFileLength(FileUtils.getFileByPath(filePath));
    }

    public static long getFileLength(File file) {
        if (!FileUtils.isFile(file)) {
            return -1L;
        }
        return file.length();
    }

    public static String getFileMD5ToString(String filePath) {
        File file = StringUtils.isSpace(filePath) ? null : new File(filePath);
        return FileUtils.getFileMD5ToString(file);
    }

    public static byte[] getFileMD5(String filePath) {
        File file = StringUtils.isSpace(filePath) ? null : new File(filePath);
        return FileUtils.getFileMD5(file);
    }

    public static String getFileMD5ToString(File file) {
        return ConvertUtils.bytes2HexString(FileUtils.getFileMD5(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] getFileMD5(File file) {
        byte[] byArray;
        if (file == null) {
            return null;
        }
        DigestInputStream dis = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            MessageDigest md = MessageDigest.getInstance("MD5");
            dis = new DigestInputStream(fis, md);
            byte[] buffer = new byte[262144];
            while (dis.read(buffer) > 0) {
            }
            md = dis.getMessageDigest();
            byArray = md.digest();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IoUtils.closeIO(dis);
                throw throwable;
            }
            IoUtils.closeIO(dis);
            return null;
        }
        IoUtils.closeIO(dis);
        return byArray;
    }

    public static String getDirName(File file) {
        if (file == null) {
            return null;
        }
        return FileUtils.getDirName(file.getPath());
    }

    public static String getDirName(String filePath) {
        if (StringUtils.isSpace(filePath)) {
            return filePath;
        }
        int lastSep = filePath.lastIndexOf(File.separator);
        return lastSep == -1 ? "" : filePath.substring(0, lastSep + 1);
    }

    public static String getFileName(File file) {
        if (file == null) {
            return null;
        }
        return FileUtils.getFileName(file.getPath());
    }

    public static String getFileName(String filePath) {
        if (StringUtils.isSpace(filePath)) {
            return filePath;
        }
        int lastSep = filePath.lastIndexOf(File.separator);
        return lastSep == -1 ? filePath : filePath.substring(lastSep + 1);
    }

    public static String getFileNameNoExtension(File file) {
        if (file == null) {
            return null;
        }
        return FileUtils.getFileNameNoExtension(file.getPath());
    }

    public static String getFileNameNoExtension(String filePath) {
        if (StringUtils.isSpace(filePath)) {
            return filePath;
        }
        int lastPoi = filePath.lastIndexOf(46);
        int lastSep = filePath.lastIndexOf(File.separator);
        if (lastSep == -1) {
            return lastPoi == -1 ? filePath : filePath.substring(0, lastPoi);
        }
        if (lastPoi == -1 || lastSep > lastPoi) {
            return filePath.substring(lastSep + 1);
        }
        return filePath.substring(lastSep + 1, lastPoi);
    }

    public static String getFileExtension(File file) {
        if (file == null) {
            return null;
        }
        return FileUtils.getFileExtension(file.getPath());
    }

    public static String getFileExtension(String filePath) {
        if (StringUtils.isSpace(filePath)) {
            return filePath;
        }
        int lastPoi = filePath.lastIndexOf(46);
        int lastSep = filePath.lastIndexOf(File.separator);
        if (lastPoi == -1 || lastSep >= lastPoi) {
            return "";
        }
        return filePath.substring(lastPoi + 1);
    }

    public static int getIconWithSuffix(String path) {
        if (path == null || "".equals(path)) {
            return R.mipmap.im_uikit_ic_others;
        }
        String suffix = path.substring(path.lastIndexOf(".") + 1).toLowerCase();
        if (TextUtils.isEmpty((CharSequence)suffix)) {
            return R.mipmap.im_uikit_ic_others;
        }
        int resId = FileUtils.isFileType(suffix = suffix.toLowerCase(), new String[]{".pdf"}) ? R.mipmap.im_uikit_ic_pdf : (FileUtils.isFileType(suffix, new String[]{".doc", ".docx"}) ? R.mipmap.im_uikit_ic_doc : (FileUtils.isFileType(suffix, new String[]{".xls", ".xlsx"}) ? R.mipmap.im_uikit_ic_excel : (FileUtils.isFileType(suffix, new String[]{".ppt", ".pptx"}) ? R.mipmap.im_uikit_ic_ppt : (FileUtils.isFileType(suffix, new String[]{".txt"}) ? R.mipmap.im_uikit_ic_text : (FileUtils.isFileType(suffix, MimeUtils.mVideoSuffix) ? R.mipmap.im_uikit_ic_video : (FileUtils.isFileType(suffix, MimeUtils.mVoiceSuffix) ? R.mipmap.im_uikit_ic_music : (FileUtils.isFileType(suffix, MimeUtils.mImageSuffix) ? R.mipmap.im_uikit_ic_jpg : (FileUtils.isFileType(suffix, MimeUtils.mDocSuffix) ? R.mipmap.im_uikit_ic_doc : (FileUtils.isFileType(suffix, MimeUtils.mApkSuffix) ? R.mipmap.im_uikit_ic_apk : R.mipmap.im_uikit_ic_others)))))))));
        return resId;
    }

    public static int getTypeWithSuffix(String path) {
        if (path == null || "".equals(path)) {
            return 11;
        }
        String suffix = path.substring(path.lastIndexOf(".") + 1).toLowerCase();
        if (TextUtils.isEmpty((CharSequence)suffix)) {
            return 11;
        }
        int type = FileUtils.isFileType(suffix = suffix.toLowerCase(), new String[]{".pdf"}) ? 9 : (FileUtils.isFileType(suffix, new String[]{".doc", ".docx"}) ? 6 : (FileUtils.isFileType(suffix, new String[]{".xls", ".xlsx"}) ? 6 : (FileUtils.isFileType(suffix, new String[]{".ppt", ".pptx"}) ? 6 : (FileUtils.isFileType(suffix, new String[]{".txt"}) ? 5 : (FileUtils.isFileType(suffix, MimeUtils.mVideoSuffix) ? 2 : (FileUtils.isFileType(suffix, MimeUtils.mVoiceSuffix) ? 11 : (FileUtils.isFileType(suffix, MimeUtils.mImageSuffix) ? 3 : (FileUtils.isFileType(suffix, MimeUtils.mDocSuffix) ? 5 : (FileUtils.isFileType(suffix, MimeUtils.mApkSuffix) ? 11 : 11)))))))));
        return type;
    }

    private static boolean isFileType(String suffix, String[] args) {
        for (String arg : args) {
            if (!arg.equals("." + suffix)) continue;
            return true;
        }
        return false;
    }
}

