/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.utils.sys;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.xdja.im.core.model.screen.ScreenInfo;
import java.lang.reflect.Method;

public class ScreenUtil {
    public static int getWidthPixels(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        Configuration cf = context.getResources().getConfiguration();
        int ori = cf.orientation;
        if (ori == 2) {
            return displayMetrics.heightPixels;
        }
        if (ori == 1) {
            return displayMetrics.widthPixels;
        }
        return 0;
    }

    public static int dp2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2dp(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    private static int getDpi(Context context) {
        int dpi = 0;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        try {
            Class<?> c = Class.forName("android.view.Display");
            Method method = c.getMethod("getRealMetrics", DisplayMetrics.class);
            method.invoke((Object)display, displayMetrics);
            dpi = displayMetrics.heightPixels;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dpi;
    }

    public static int getBottomStatusHeight(Context context) {
        int totalHeight = ScreenUtil.getDpi(context);
        int contentHeight = ScreenUtil.getScreenHeight(context);
        return totalHeight - contentHeight;
    }

    public static int getScreenHeight(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(outMetrics);
        return outMetrics.heightPixels;
    }

    public static ScreenInfo getScreenInfo(Activity activity) {
        WindowManager wm = activity.getWindowManager();
        DisplayMetrics metric = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metric);
        ScreenInfo screenInfo = new ScreenInfo();
        screenInfo.setDensity(metric.density);
        screenInfo.setDensityDpi(metric.densityDpi);
        screenInfo.setHeight(metric.heightPixels);
        screenInfo.setWidth(metric.widthPixels);
        return screenInfo;
    }
}

