/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.volley.toolbox;

import android.text.TextUtils;
import com.xdja.imsdk.volley.CustomRetryPolicy;
import com.xdja.imsdk.volley.RequestQueue;
import com.xdja.imsdk.volley.Response;
import com.xdja.imsdk.volley.VolleyLog;
import com.xdja.imsdk.volley.error.CancelError;
import com.xdja.imsdk.volley.error.VolleyError;
import com.xdja.imsdk.volley.request.DownloadRequest;
import com.xdja.imsdk.volley.toolbox.HttpCallback;
import java.util.LinkedList;

public class FileDownloader {
    private static final int STATUS_WAITING = 0;
    private static final int STATUS_DOWNLOADING = 1;
    private static final int STATUS_PAUSE = 2;
    private static final int STATUS_SUCCESS = 3;
    private static final int STATUS_DISCARD = 4;
    private final RequestQueue mRequestQueue;
    private final int mParallelTaskCount;
    private LinkedList<DownloadController> mTaskQueue;

    public FileDownloader(RequestQueue queue, int taskCount) {
        this.mRequestQueue = queue;
        this.mParallelTaskCount = taskCount;
        this.mTaskQueue = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule() {
        LinkedList<DownloadController> linkedList = this.mTaskQueue;
        synchronized (linkedList) {
            int parallelTaskCount = 0;
            for (DownloadController controller : this.mTaskQueue) {
                if (!controller.isDownloading()) continue;
                ++parallelTaskCount;
            }
            if (parallelTaskCount >= this.mParallelTaskCount) {
                return;
            }
            for (DownloadController controller : this.mTaskQueue) {
                if (!controller.deploy() || ++parallelTaskCount != this.mParallelTaskCount) continue;
                return;
            }
        }
    }

    private boolean isTaskExist(String url, String tag) {
        for (DownloadController ctrl : this.mTaskQueue) {
            if (!TextUtils.equals((CharSequence)ctrl.mUrl, (CharSequence)url) || !TextUtils.equals((CharSequence)ctrl.mTag, (CharSequence)tag)) continue;
            VolleyLog.d("task is already exist!", new Object[0]);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String url, String storePath, String tag, long fileSize, boolean isSupportRange, CustomRetryPolicy policy, HttpCallback callback) {
        LinkedList<DownloadController> linkedList = this.mTaskQueue;
        synchronized (linkedList) {
            if (this.isTaskExist(url, tag)) {
                return;
            }
            DownloadController controller = new DownloadController(url, fileSize, storePath, tag, isSupportRange, policy, callback);
            this.mTaskQueue.add(controller);
            this.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadController get(String url) {
        LinkedList<DownloadController> linkedList = this.mTaskQueue;
        synchronized (linkedList) {
            VolleyLog.d("mTaskQueue.size:" + this.mTaskQueue.size() + ",url:" + url, new Object[0]);
            for (DownloadController controller : this.mTaskQueue) {
                VolleyLog.d("DownloadController:" + controller.mUrl, new Object[0]);
                if (!controller.mUrl.equals(url)) continue;
                return controller;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadController getByTag(String tag) {
        LinkedList<DownloadController> linkedList = this.mTaskQueue;
        synchronized (linkedList) {
            VolleyLog.d("mTaskQueue.size:" + this.mTaskQueue.size() + ",tag:" + tag, new Object[0]);
            for (DownloadController controller : this.mTaskQueue) {
                VolleyLog.d("DownloadController:" + controller.mUrl, new Object[0]);
                if (!controller.mTag.equals(tag)) continue;
                return controller;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(DownloadController controller) {
        LinkedList<DownloadController> linkedList = this.mTaskQueue;
        synchronized (linkedList) {
            VolleyLog.d("mTaskQueue.remove:" + this.mTaskQueue.size(), new Object[0]);
            this.mTaskQueue.remove(controller);
            this.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        LinkedList<DownloadController> linkedList = this.mTaskQueue;
        synchronized (linkedList) {
            for (DownloadController controller : this.mTaskQueue) {
                if (controller == null || controller.mStatus != 1) continue;
                controller.mRequest.cancel();
            }
        }
        this.mTaskQueue.clear();
    }

    public void cancel(String requestTag) {
        DownloadController controller = this.getByTag(requestTag);
        if (controller != null) {
            controller.mStatus = 4;
        }
    }

    public class DownloadController {
        private String mUrl;
        private long mFileSize;
        private String mStorePath;
        private String mTag;
        private boolean bSupportRange;
        private HttpCallback mCallback;
        private DownloadRequest mRequest;
        private int mStatus;
        private int mPercent;
        private CustomRetryPolicy policy;

        public DownloadController(String url, long fileSize, String storePath, String tag, boolean isSupportRange, CustomRetryPolicy retryPolicy, HttpCallback callback) {
            this.mUrl = url;
            this.mFileSize = fileSize;
            this.mStorePath = storePath;
            this.mTag = tag;
            this.bSupportRange = isSupportRange;
            this.mCallback = callback;
            this.policy = retryPolicy == null ? new CustomRetryPolicy() : retryPolicy;
        }

        private boolean deploy() {
            if (this.mStatus != 0) {
                return false;
            }
            if (this.mRequest == null) {
                this.mRequest = new DownloadRequest(this.mUrl, (Response.Listener)new Response.Listener<String>(){

                    @Override
                    public void onResponse(String response) {
                        VolleyLog.d("download finished for:" + DownloadController.this.toString() + "\nResponse:" + response, new Object[0]);
                        if (DownloadController.this.mCallback != null) {
                            DownloadController.this.mStatus = 3;
                            DownloadController.this.mCallback.onResult(response);
                            DownloadController.this.mCallback.onFinish();
                        }
                        FileDownloader.this.remove(DownloadController.this);
                    }
                }, new Response.ErrorListener(){

                    @Override
                    public void onErrorResponse(VolleyError error) {
                        VolleyLog.e("onErrorResponse:" + error.getMessage(), new Object[0]);
                        if (DownloadController.this.mCallback != null && DownloadController.this.mStatus != 2) {
                            VolleyLog.d("Error:" + DownloadController.this.toString(), new Object[0]);
                            if (!(error instanceof CancelError)) {
                                DownloadController.this.mCallback.onError(error);
                            }
                            DownloadController.this.mStatus = 4;
                            FileDownloader.this.remove(DownloadController.this);
                            FileDownloader.this.mRequestQueue.cancelAll(DownloadController.this.mTag);
                        } else if (DownloadController.this.mCallback != null) {
                            VolleyLog.d("Download Canceled for:" + DownloadController.this.toString(), new Object[0]);
                            DownloadController.this.mCallback.onCanceled();
                        }
                    }
                }, new Response.LoadingListener(){

                    @Override
                    public void onLoading(long count, long current) {
                        int percent;
                        VolleyLog.d("Downloading process for " + DownloadController.this.mTag + ", fileSize:" + count + ", translateSize:" + current, new Object[0]);
                        if (DownloadController.this.mCallback != null && DownloadController.this.mStatus == 1 && count > 0L && ((percent = (int)((float)current * 100.0f / (float)count)) > DownloadController.this.mPercent || percent == 100)) {
                            DownloadController.this.mPercent = percent;
                            DownloadController.this.mCallback.onLoading(count, current, percent);
                        }
                    }
                }, new Response.CanceledListener(){

                    @Override
                    public void onCanceled() {
                        VolleyLog.d("Download Canceled for:" + DownloadController.this.toString(), new Object[0]);
                        if (DownloadController.this.mStatus == 2) {
                            if (DownloadController.this.mCallback != null) {
                                DownloadController.this.mCallback.onCanceled();
                            }
                        } else {
                            DownloadController.this.mPercent = 0;
                            FileDownloader.this.remove(DownloadController.this);
                        }
                    }
                }){

                    @Override
                    public void onNetChange(int code, String message) {
                        super.onNetChange(code, message);
                        if (DownloadController.this.mCallback != null) {
                            DownloadController.this.mCallback.onNetChanged(code, message);
                        }
                    }
                };
            }
            if (this.mCallback != null) {
                this.mCallback.onStart();
            }
            this.mStatus = 1;
            this.mRequest.setRetryPolicy(this.policy);
            this.mRequest.setTag(this.mTag);
            this.mRequest.setTarget(this.mStorePath, this.mFileSize, this.bSupportRange);
            this.mRequest.prepare();
            FileDownloader.this.mRequestQueue.add(this.mRequest);
            return true;
        }

        public int getStatus() {
            return this.mStatus;
        }

        public boolean isDownloading() {
            return this.mStatus == 1;
        }

        public boolean isPause() {
            return this.mStatus == 2;
        }

        public boolean pause(String tag) {
            VolleyLog.d("Download pause for:" + this.toString(), new Object[0]);
            switch (this.mStatus) {
                case 1: {
                    this.mStatus = 2;
                    this.mRequest.cancel();
                    FileDownloader.this.mRequestQueue.cancelAll(tag);
                    break;
                }
                case 0: {
                    this.mStatus = 2;
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        public boolean resume() {
            VolleyLog.d("Download resume for:" + this.toString(), new Object[0]);
            this.mStatus = 0;
            this.bSupportRange = true;
            this.mRequest.resume();
            FileDownloader.this.schedule();
            return true;
        }

        public boolean stop() {
            VolleyLog.d("DownloadController.discard...", new Object[0]);
            if (this.mStatus == 4) {
                return false;
            }
            if (this.mStatus == 3) {
                return false;
            }
            if (this.mStatus == 1) {
                this.mRequest.cancel();
            }
            this.mStatus = 4;
            FileDownloader.this.remove(this);
            return true;
        }

        public String toString() {
            return "DownloadController{mUrl='" + this.mUrl + '\'' + ", mFileSize=" + this.mFileSize + ", mStorePath='" + this.mStorePath + '\'' + ", mTag='" + this.mTag + '\'' + ", mStatus=" + this.mStatus + ", mPercent=" + this.mPercent + '}';
        }
    }
}

