package com.xdja.im.base.frame.presenter;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;

import com.xdja.im.base.frame.Presenter;
import com.xdja.im.base.frame.view.AdapterBaseView;

import java.util.List;

/**
 * @Package:com.xdja.im.base.frame.presenter
 * @Author:Lei
 * @Creation:2017-04-13 00:31
 * @Version 1.0
 * @Description:
 */
public abstract class BaseItemAdapterPresenter<P extends Presenter, D> extends BaseAdapter {

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {

        AdapterBaseView<P, D> adapterVu = null;
        if (convertView == null) {
            try {
                int itemViewType = getItemViewType(position);
                Class<? extends AdapterBaseView> aClass = getVuClassByViewType(itemViewType);
                if (aClass != null) {
                    adapterVu = aClass.newInstance();
                    adapterVu.setPresenter(getPresenter());
                    adapterVu.setActivity(getActivity());

                    adapterVu.init(LayoutInflater.from(parent.getContext()), parent);
                    convertView = adapterVu.getView();
                    convertView.setTag(adapterVu);
                    adapterVu.onViewCreated();
                } else {
                    throw new NullPointerException("item view type error!");
                }
            } catch (InstantiationException e) {
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else {
            adapterVu = (AdapterBaseView<P, D>) convertView.getTag();
            adapterVu.onViewReused();
        }
        adapterVu.bindDataSource(position, getDataSource(position));
        return convertView;
    }

    protected abstract List<Class<? extends AdapterBaseView<P, D>>> getVuClasses();

    protected abstract P getPresenter();

    protected abstract D getDataSource(int position);

    /**
     * 根据View类型获取对应的View类型定义
     *
     * @return View类型
     */
    @NonNull
    protected Class<? extends AdapterBaseView<P, D>> getVuClassByViewType(int itemViewType) {
        if (this.getVuClasses() != null) {
            if (itemViewType < this.getVuClasses().size()) {
                return this.getVuClasses().get(itemViewType);
            }
        }
        return null;
    }

    protected Activity getActivity() {
        return null;
    }
}
