package com.xdja.im.base.frame.view;

import android.support.annotation.NonNull;

import com.xdja.im.base.frame.BaseView;
import com.xdja.im.base.frame.Presenter;

/**
 * @Package:com.xdja.im.base.frame.view
 * @Author:Lei
 * @Creation:2017-04-13 00:32
 * @Version 1.0
 * @Description:
 */
public interface AdapterBaseView<P extends Presenter, D> extends BaseView<P> {

    /**
     * 适配器相关的View被新创建出来
     */
    void onViewCreated();

    /**
     * 适配器相关的View被重用
     */
    void onViewReused();

    /**
     * 绑定数据源到View上
     *
     * @param position   当前Item位置
     * @param dataSource 数据
     */
    void bindDataSource(int position, @NonNull D dataSource);
}
