package com.xdja.im.common.cache.impl;

import android.text.TextUtils;

import com.xdja.im.common.cache.entity.UserEntity;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;

import java.util.HashMap;
import java.util.Map;

import javax.inject.Inject;

/**
 * @Package: com.xdja.im.common.cache.impl
 * @Author: xdjaxa
 * @Creation: 2017-05-04 15:52
 * @Version V1.0
 * @Description:
 */
public class UserCacheImpl implements UserCache {

    private UserEntity userEntity;

    private Map<Long, Integer> mPercentMaps;

    @Inject
    public UserCacheImpl() {
        mPercentMaps = new HashMap<>();
    }

    @Override
    public void put(UserEntity userEntity) {
        this.userEntity = userEntity;
    }

    @Override
    public UserEntity get() {
        return userEntity;
    }

    @Override
    public boolean isMine(String account) {
        if (TextUtils.isEmpty(account)) {
            return false;
        }
        if (userEntity == null) {
            return false;
        }
        return account.equals(userEntity.getAccount());
    }


    @Override
    public void putProgress(long msgId, int percent) {
        if (mPercentMaps == null) {
            mPercentMaps = new HashMap<>();
        }

        mPercentMaps.put(msgId, percent);
    }

    @Override
    public int getProgress(long msgId) {
        return mPercentMaps.containsKey(msgId) ? mPercentMaps.get(msgId) : 0;
    }

    @Override
    public void removeProgress(long msgId) {
        if (mPercentMaps.containsKey(msgId)) {
            mPercentMaps.remove(msgId);
        }
    }

    @Override
    public boolean containKey(long msgId) {
        return mPercentMaps != null && mPercentMaps.containsKey(msgId);// modified by ycm for lint 2017/02/16
    }

    @Override
    public void clearAllProgress() {
        if (mPercentMaps != null && mPercentMaps.size() > 0) {
            mPercentMaps.clear();
            mPercentMaps = null;
        }
    }

    @Override
    public String getImRecallMsg(String account, String groupId) {
        if (null == account) {
            return null;
        }
        AccountBean info;
        //modify by zya,fix bug 11802,20170425
        //Activity activity = ActivityStack.getInstanse().getTopActivity();
        if (isMine(account)) {
            return ImUiKit.getInstance().getContext().getString(R.string.im_uikit_you_recall_message);
        } else {
            info = IMUiKitProxyImpl.getInstance().getAccount(account, ConstDef.CHAT_TYPE_P2P);
            if (info != null) {
                return info.getDisplayName() + ImUiKit.getInstance().getContext().getString(R.string.im_uikit_recall_message);
            } else return "消息被撤回";
        }//end by zya
    }
}
