package com.xdja.im.common.database.builder;

/**
 * @Package: com.xdja.im.common.database.builder
 * @Author: xdjaxa
 * @Creation: 2017-05-22 17:51
 * @Version V1.0
 * @Description:
 */
public class SessionEntityBuilder {

    public static final String TABLE_NAME = "t_session";


    public static final String ID = "_id";                          // 数据库id
    public static final String SESSION_FLAG = "sessionFlag";        // 会话标识
    public static final String SESSION_MODE = "sessionMode";        // 会话置顶
    public static final String SESSION_DISTURB = "sessionDisturb";  // 会话免打扰
    public static final String RECEIVE_MODE = "receiverMode";       // 听筒模式
    public static final String DRAFT_CONTENT = "draftContent";      // 草稿内容
    public static final String DRAFT_TIME = "draftCreateTime";      // 草稿创建时间

    private static final String[] ALL_COLUMNS = {ID, SESSION_FLAG, SESSION_MODE,
            SESSION_DISTURB, RECEIVE_MODE, DRAFT_CONTENT, DRAFT_TIME};

    public static final String SQL_CREATE_TABLE_SESSION_ENTRY =
            "CREATE TABLE " + TABLE_NAME + " ("
                    + ID + " INTEGER PRIMARY KEY AUTOINCREMENT,"
                    + SESSION_FLAG + " TEXT UNIQUE NOT NULL,"
                    + SESSION_MODE + " INTEGER DEFAULT 0,"
                    + SESSION_DISTURB + " INTEGER DEFAULT 0,"
                    + RECEIVE_MODE + " INTEGER DEFAULT 0,"
                    + DRAFT_CONTENT + " TEXT,"
                    + DRAFT_TIME + " INTEGER DEFAULT 0)";

    /**
     * 插入
     * INSERT OR REPLACE INTO session_entry (...) VALUES(...);
     *
     * @return sql
     */
    public static String insertSql() {
        return SqlBuilder.insertSql("INSERT OR REPLACE INTO ",
                TABLE_NAME, ALL_COLUMNS);
    }

    public static String delSql(String sessionFlag) {
        return SqlBuilder.deleteSql(TABLE_NAME, SESSION_FLAG, sessionFlag);
    }

    public static String delAllSql() {
        return SqlBuilder.deleteAll(TABLE_NAME);
    }

    public static String querySql(String sessionFlag) {
        StringBuilder builder = new StringBuilder("SELECT * FROM ");
        builder.append(TABLE_NAME);
        builder.append(" WHERE ").append(TABLE_NAME).append(".").
                append(SESSION_FLAG).append(" = '").append(sessionFlag).append("'");
        return builder.toString();
    }

    public static String queryAll() {
        return SqlBuilder.selectAll(TABLE_NAME);
    }
}
