package com.xdja.im.common.database.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import com.xdja.im.common.database.DatabaseManager;
import com.xdja.im.common.database.bean.SettingDb;
import com.xdja.im.common.database.builder.SessionEntityBuilder;
import com.xdja.im.common.database.builder.SettingEntityBuilder;
import com.xdja.im.common.database.helper.UpdateArgs;

/**
 * @Package: com.xdja.im.common.database.dao
 * @Author: xdjaxa
 * @Creation: 2017-05-22 15:53
 * @Version V1.0
 * @Description:
 */
public class SettingEntityDao extends AbstractDao<SettingDb> {


    private SettingEntityDao() {
    }

    private static class SingletonInstance {
        private static final SettingEntityDao mInstance = new SettingEntityDao();
    }

    public static SettingEntityDao getInstance() {
        return SingletonInstance.mInstance;
    }

    public SettingDb get() {
        SettingDb msgEntryDb = null;
        Cursor cursor = null;
        try {
            cursor = query(SettingEntityBuilder.querySql());
            if (cursor != null && cursor.moveToNext()) {
                msgEntryDb = readEntry(cursor, 0);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            closeCursor(cursor);
        }
        return msgEntryDb;
    }

    public long insert(SettingDb settingDb) {
        SQLiteDatabase db = getDatabase();
        if (db != null) {
            return insert(db, settingDb, SettingEntityBuilder.insertSql());
        }
        return -1;
    }

    public void update(SettingDb settingDb) {
        UpdateArgs args = new UpdateArgs(SettingEntityBuilder.TABLE_NAME);
        ContentValues values = new ContentValues();

        values.put(SettingEntityBuilder.ACCOUNT, settingDb.getAccount());
        values.put(SettingEntityBuilder.REMIND_TYPE, settingDb.getRemindType());
        values.put(SettingEntityBuilder.TYPE_VOICE, settingDb.getRemindVoice());
        values.put(SettingEntityBuilder.TYPE_VIBRATE, settingDb.getRemindVibrate());
        values.put(SettingEntityBuilder.RECEIVE_MODE, settingDb.getReceiverMode());
        values.put(SettingEntityBuilder.DISTURB_MODE, settingDb.getDisturbMode());
        values.put(SettingEntityBuilder.DISTURB_START, settingDb.getDisturbStart());
        values.put(SettingEntityBuilder.DISTURB_END, settingDb.getDisturbEnd());

        String whereClause[] = new String[]{SettingEntityBuilder.ACCOUNT};
        String[] whereArgs = new String[]{settingDb.getAccount()};

        args.setValues(values);
        args.setWhereClause(whereClause);
        args.setWhereArgs(whereArgs);
        update(args);
    }

    @Override
    protected SettingDb readEntry(Cursor cursor, int offset) {
        SettingDb entity = new SettingDb(
                cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0),
                cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1),
                cursor.isNull(offset + 2) ? null : cursor.getInt(offset + 2),
                cursor.isNull(offset + 3) ? null : cursor.getInt(offset + 3),
                cursor.isNull(offset + 4) ? null : cursor.getInt(offset + 4),
                cursor.isNull(offset + 5) ? null : cursor.getInt(offset + 5),
                cursor.isNull(offset + 6) ? null : cursor.getInt(offset + 6),
                cursor.isNull(offset + 7) ? null : cursor.getLong(offset + 7),
                cursor.isNull(offset + 8) ? null : cursor.getLong(offset + 8)
        );
        return entity;
    }

    @Override
    public void bindValues(SQLiteStatement stmt, SettingDb entity) {
        stmt.clearBindings();
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }

        String account = entity.getAccount();
        if (account != null) {
            stmt.bindString(2, account);
        }

        Integer remindType = entity.getRemindType();
        if (remindType != null) {
            stmt.bindLong(3, remindType);
        }

        Integer remindVoice = entity.getRemindVoice();
        if (remindVoice != null) {
            stmt.bindLong(4, remindVoice);
        }

        Integer remindVibrate = entity.getRemindVibrate();
        if (remindVibrate != null) {
            stmt.bindLong(5, remindVibrate);
        }

        Integer receiverMode = entity.getReceiverMode();
        if (receiverMode != null) {
            stmt.bindLong(6, receiverMode);
        }

        Integer disturbMode = entity.getDisturbMode();
        if (disturbMode != null) {
            stmt.bindLong(7, disturbMode);
        }

        Long disturbStart = entity.getDisturbStart();
        if (disturbStart != null) {
            stmt.bindLong(8, disturbStart);
        }

        Long disturbEnd = entity.getDisturbEnd();
        if (disturbEnd != null) {
            stmt.bindLong(9, disturbEnd);
        }
    }

    /**
     * 获取数据库句柄
     *
     * @return
     * @throws IllegalAccessError 数据库句柄为空异常
     */
    private SQLiteDatabase getDatabase() {
        SQLiteDatabase db = DatabaseManager.getInstance().getDatabase();
        if (db == null) {
            throw new IllegalAccessError("open database failed.");
        }
        return db;
    }

}
