package com.xdja.im.core.model.event;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.file.FileInfo;

/**
 * @Package: com.xdja.im.core.model.event
 * @Author: xdjaxa
 * @Creation: 2017-05-11 21:49
 * @Version V1.0
 * @Description:
 */
public class IMProxyFileEvent {

    /**
     * 文件相关事件定义
     */
    public static class FileEvent {
        /**
         * 文件ID
         */
        private long fileId;
        /**
         * 所属消息ID
         */
        private long attachedMsgId;
        /**
         * 所属会话ID
         */
        private String attachedTalkId;
        /**
         * 文件对象
         */
        private FileInfo fileInfo;

        public long getFileId() {
            return fileId;
        }

        public void setFileId(long fileId) {
            this.fileId = fileId;
        }

        public long getAttachedMsgId() {
            return attachedMsgId;
        }

        public void setAttachedMsgId(long attachedMsgId) {
            this.attachedMsgId = attachedMsgId;
        }

        public String getAttachedTalkId() {
            return attachedTalkId;
        }

        public void setAttachedTalkId(String attachedTalkId) {
            this.attachedTalkId = attachedTalkId;
        }

        public FileInfo getFileInfo() {
            return fileInfo;
        }

        public void setFileInfo(FileInfo fileInfo) {
            this.fileInfo = fileInfo;
        }

        @Override
        public String toString() {
            return "FileEvent{" +
                    "fileId=" + fileId +
                    ", attachedMsgId=" + attachedMsgId +
                    ", attachedTalkId='" + attachedTalkId + '\'' +
                    ", fileInfo=" + fileInfo +
                    '}';
        }
    }

    /**
     * 文件发送完成事件
     */
    public static class SendFileFinishedEvent extends FileEvent {
    }

    /**
     * 文件接收完成事件
     */
    public static class ReceiveFileFinishedEvent extends FileEvent {
    }

    /**
     * 文件发送失败事件
     */
    public static class SendFileFailedEvent extends FileEvent {
    }

    /**
     * 文件接收失败事件
     */
    public static class ReceiveFileFailedEvent extends FileEvent {
    }

    /**
     * 发送文件暂停事件
     */
    public static class SendFilePausedEvent extends FileEvent {
    }

    /**
     * 接收文件暂停事件
     */
    public static class ReceiveFilePausedEvent extends FileEvent {
    }

    /**
     * 文件传输进度更新事件
     */
    public static class FileProgressUpdateEvent extends FileEvent {
        /**
         * 文件传输百分比
         */
        private int percent;

        /**
         * 文件类型
         */
        @ConstDef.FileProperty
        private int fileProperty;

        public int getPercent() {
            return percent;
        }

        public void setPercent(int percent) {
            this.percent = percent;
        }

        public int getFileProperty() {
            return fileProperty;
        }

        public void setFileProperty(int fileProperty) {
            this.fileProperty = fileProperty;
        }
    }

    /**
     * 文件发送进度更新事件
     */
    public static class SendFileProgressUpdateEvent extends FileProgressUpdateEvent {
    }

    /**
     * 接收文件进度更新事件
     */
    public static class ReceiveFileProgressUpdateEvent extends FileProgressUpdateEvent {
    }



    /**
     * 聊天文件
     */
    public static class HistoryFileEvent {

    }
}
