package com.xdja.im.core.proxy;

import com.xdja.im.core.model.param.RemindAction;
import com.xdja.im.core.model.param.SettingParam;

/**
 * @Package: com.xdja.im.core.proxy
 * @Author: xdjaxa
 * @Creation: 2017-08-08 17:45
 * @Version V1.0
 * @Description:
 */
public interface IMUiKitSettingProxy {

    /**
     * 获取当前登录账号的设置参数信息
     *
     * @return
     */
    SettingParam getSettingParam();

    /**
     * 更改提醒方式
     *
     * @param action {@link com.xdja.im.core.model.param.RemindAction.Action}
     */
    void setRemindType(@RemindAction.Action int action);

    /**
     * 设置听筒模式
     *
     * @param isOpen {@code true}：开启；{@code false}：关闭
     */
    void setReceiveMode(boolean isOpen);

    /**
     * 设置勿扰方式
     *
     * @param isOpen
     */
    void setDisturbMode(boolean isOpen);

    /**
     * 勿扰开始时间
     *
     * @param disturbStart
     */
    void setDisturbStart(long disturbStart);

    /**
     * 勿扰结束时间
     *
     * @param disturbEnd
     */
    void setDisturbEnd(long disturbEnd);
}

