package com.xdja.im.core.service;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import com.xdja.im.core.config.ConstDef;


/**
 * @Package: com.xdja.im.core.service
 * @Author: xdjaxa
 * @Creation: 2017-06-29 15:29
 * @Version V1.0
 * @Description:
 */
public class NetworkStatusReceiver extends BroadcastReceiver {

    @Override
    public void onReceive(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        String state = intent.getStringExtra(ConstDef.PUSH_CODE);
        if (ConstDef.PUSH_CONNECTED.equals(state)) {
            Intent serviceIntent = new Intent(context, KitService.class);
            serviceIntent.setAction(ConstDef.IM_PUSH_STATE);
            context.startService(serviceIntent);
        }
    }
}
