package com.xdja.im.lib.camera.bean;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * @Package: com.xdja.im.lib.camera.bean
 * @Author: xdjaxa
 * @Creation: 2017-05-13 17:30
 * @Version V1.0
 * @Description:
 */
public class PhotoItem implements Parcelable{

    /**
     * 文件名称
     */
    private String fileName;
    /**
     * 文件路径
     */
    private String filePath;
    /**
     * 文件大小
     */
    private long fileSize;
    /**
     * 文件后缀名
     */
    private String suffix;

    public boolean isbOriginal() {
        return bOriginal;
    }

    public void setbOriginal(boolean bOriginal) {
        this.bOriginal = bOriginal;
    }

    /**
     * 原图选择状态 {@code false}：未选择 {@code true}：选择
     */
    private boolean bOriginal;

    public PhotoItem() {
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public long getFileSize() {
        return fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String getSuffix() {
        return suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public String toString() {
        return "PhotoItem{" +
                "fileName='" + fileName + '\'' +
                ", filePath='" + filePath + '\'' +
                ", fileSize=" + fileSize +
                ", suffix='" + suffix + '\'' +
                '}';
    }

    protected PhotoItem(Parcel in) {
        fileName = in.readString();
        filePath = in.readString();
        fileSize = in.readLong();
        suffix = in.readString();
    }

    public static final Creator<PhotoItem> CREATOR = new Creator<PhotoItem>() {
        @Override
        public PhotoItem createFromParcel(Parcel in) {
            return new PhotoItem(in);
        }

        @Override
        public PhotoItem[] newArray(int size) {
            return new PhotoItem[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(fileName);
        dest.writeString(filePath);
        dest.writeLong(fileSize);
        dest.writeString(suffix);
    }
}
