package com.xdja.im.lib.camera.bean;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * @Package: com.xdja.im.lib.album.bean
 * @Author: xdjaxa
 * @Creation: 2017-05-02 14:00
 * @Version V1.0
 * @Description:图片缩略图信息
 */
public class PhotoThumbBean implements Parcelable {

    /**
     * 缩略图文件名称
     */
    private String thumbName;
    /**
     * 缩略图路径
     */
    private String thumbPath;
    /**
     * 缩略图大小
     */
    private long thumbSize;

    /**
     * 高清缩略图名称
     */
    private String hdThumbName;
    /**
     * 高清缩略图地址
     */
    private String hdThumbPath;
    /**
     * 高清缩略图大小
     */
    private long hdThumbSize;

    /**
     * 原图名称
     */
    private String rawName;
    /**
     * 原图地址
     */
    private String rawPath;
    /**
     * 原图大小
     */
    private long rawSize;

    public PhotoThumbBean() {
    }

    public String getThumbName() {
        return thumbName;
    }

    public void setThumbName(String thumbName) {
        this.thumbName = thumbName;
    }

    public String getThumbPath() {
        return thumbPath;
    }

    public void setThumbPath(String thumbPath) {
        this.thumbPath = thumbPath;
    }

    public long getThumbSize() {
        return thumbSize;
    }

    public void setThumbSize(long thumbSize) {
        this.thumbSize = thumbSize;
    }

    public String getHdThumbName() {
        return hdThumbName;
    }

    public void setHdThumbName(String hdThumbName) {
        this.hdThumbName = hdThumbName;
    }

    public String getHdThumbPath() {
        return hdThumbPath;
    }

    public void setHdThumbPath(String hdThumbPath) {
        this.hdThumbPath = hdThumbPath;
    }

    public long getHdThumbSize() {
        return hdThumbSize;
    }

    public void setHdThumbSize(long hdThumbSize) {
        this.hdThumbSize = hdThumbSize;
    }

    public String getRawName() {
        return rawName;
    }

    public void setRawName(String rawName) {
        this.rawName = rawName;
    }

    public String getRawPath() {
        return rawPath;
    }

    public void setRawPath(String rawPath) {
        this.rawPath = rawPath;
    }

    public long getRawSize() {
        return rawSize;
    }

    public void setRawSize(long rawSize) {
        this.rawSize = rawSize;
    }

    @Override
    public String toString() {
        return "ImageThumbBean{" +
                "thumbName='" + thumbName + '\'' +
                ", thumbPath='" + thumbPath + '\'' +
                ", thumbSize=" + thumbSize +
                ", hdThumbName='" + hdThumbName + '\'' +
                ", hdThumbPath='" + hdThumbPath + '\'' +
                ", hdThumbSize=" + hdThumbSize +
                ", rawName='" + rawName + '\'' +
                ", rawPath='" + rawPath + '\'' +
                ", rawSize=" + rawSize +
                '}';
    }

    protected PhotoThumbBean(Parcel in) {
        thumbName = in.readString();
        thumbPath = in.readString();
        thumbSize = in.readLong();
        hdThumbName = in.readString();
        hdThumbPath = in.readString();
        hdThumbSize = in.readLong();
        rawName = in.readString();
        rawPath = in.readString();
        rawSize = in.readLong();
    }

    public static final Creator<PhotoThumbBean> CREATOR = new Creator<PhotoThumbBean>() {
        @Override
        public PhotoThumbBean createFromParcel(Parcel in) {
            return new PhotoThumbBean(in);
        }

        @Override
        public PhotoThumbBean[] newArray(int size) {
            return new PhotoThumbBean[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(thumbName);
        dest.writeString(thumbPath);
        dest.writeLong(thumbSize);
        dest.writeString(hdThumbName);
        dest.writeString(hdThumbPath);
        dest.writeLong(hdThumbSize);
        dest.writeString(rawName);
        dest.writeString(rawPath);
        dest.writeLong(rawSize);
    }
}
