package com.xdja.im.lib.filemanage.fragment;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ExpandableListView;
import android.widget.LinearLayout;

import com.xdja.im.lib.filemanage.commend.ILastFileListCommand;
import com.xdja.im.lib.filemanage.view.FragmentSuperView;
import com.xdja.im.lib.filemanage.view.ILastFileListFragmentVu;
import com.xdja.im.uikit.R;

/**
 * 项目名称：Blade
 * 类描述：
 * 创建人：xdjaxa
 * 创建时间：2016/12/8 17:10
 * 修改人：xdjaxa
 * 修改时间：2016/12/8 17:10
 * 修改备注：
 */
public class ViewLastFileListFragment extends FragmentSuperView<ILastFileListCommand> implements ILastFileListFragmentVu,
    View.OnClickListener{


    private ExpandableListView mListView;

    private LinearLayout mEmptyLayout;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_fragment_history_file;
    }

    @Override
    protected void injectView() {
        super.injectView();

        View view = getView();
        if(getView() != null){
            mEmptyLayout = (LinearLayout) view.findViewById(R.id.history_file_empty_layout);
            mListView = (ExpandableListView) view.findViewById(R.id.lv_chat_file_history);
        }
    }

    @Override
    public void init(LayoutInflater inflater, ViewGroup container) {
        super.init(inflater, container);
        addListeners();
        initView();
    }

    private void initView(){
        mListView.setGroupIndicator(getDrawableRes(R.drawable.im_uikit_item_group_indeicator_selector));
    }

    public void showEmpty(boolean isShowEmpty){
        mEmptyLayout.setVisibility(isShowEmpty ? View.VISIBLE : View.GONE);
    }

    @Override
    public void refreshSelectHint(int num) {

    }

    private void addListeners(){
    }

    @Override
    public void onClick(View v) {

    }

    @Override
    public boolean refreshUI(){

        return false;
    }

    @Override
    public ExpandableListView getListView() {
        return mListView;
    }
}
