package com.xdja.im.lib.filemanage.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.SystemClock;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.uikit.R;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by wanghao on 2015/11/26.
 */
public class DateUtils {

    private static String serverTime;

    private static final Map<String, ThreadLocal<SimpleDateFormat>> sdfMap = new HashMap<>();

    private static final String YMDHM = "yyyy-MM-dd HH:mm";

    /**
     * 根据map中的key值，获取对应线程中的SimpleDateFormat实例
     * @param pattern
     * @return
     */
    private static SimpleDateFormat getFormat(final String pattern) {

        ThreadLocal<SimpleDateFormat> formatThread = sdfMap.get(pattern);
        if (formatThread == null) {
            //双层检查，防止sdfMap多次放值
            synchronized (DateUtils.class) {
                formatThread = new ThreadLocal<SimpleDateFormat>() {

                    @Override
                    protected SimpleDateFormat initialValue() {
                        return new SimpleDateFormat(pattern);
                    }
                };
                sdfMap.put(pattern, formatThread);
            }
        }
        return formatThread.get();
    }

    /**
     * 时间转换
     * @param timestamp
     * @return
     */
    @SuppressLint("ConstantConditions")
    public static String displayTime(Context context, long timestamp)  {
        String timeStr;
        //modify by zya 20161201
        SimpleDateFormat yh = getFormat(ActomaController.getAppConfigContext().getString(R.string.im_uikit_year_month_day));
        SimpleDateFormat mh = getFormat(ActomaController.getAppConfigContext().getString(R.string.im_uikit_month_day));

        /*SimpleDateFormat yh = new SimpleDateFormat("y" + ActomaController.getApp().getString(R.string.year) + "M"+
                ActomaController.getApp().getString(R.string.month) + "d" + ActomaController.getApp().getString(R.string.day));
        SimpleDateFormat mh = new SimpleDateFormat("M" + ActomaController.getApp().getString(R.string.month) +
                "d" + ActomaController.getApp().getString(R.string.day));*/
        //end by zya
        SimpleDateFormat hm = new SimpleDateFormat("HH:mm");
        long currentSeconds = System.currentTimeMillis();//系统当前时间
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentSeconds);

        //[S] fix bug 12039 by licong
        //系统当前年份、当前是哪一天
        int currentYear = cal.get(Calendar.YEAR);
        int currentMonth = cal.get(Calendar.MONTH);
        int currentDay  = cal.get(Calendar.DAY_OF_MONTH);

        //参数的年份，哪一天
        cal.setTimeInMillis(timestamp);
        int lastYear = cal.get(Calendar.YEAR);
        int lastMonth = cal.get(Calendar.MONTH);
        int lastDay  = cal.get(Calendar.DAY_OF_MONTH);

        if (currentYear == lastYear) {
            if (currentMonth == lastMonth && currentDay == lastDay) {
                // 今天
                timeStr = context.getResources().getString(R.string.im_uikit_today) + "   "  + hm.format(timestamp);
            } else if (currentMonth == lastMonth && ((currentDay-lastDay) == 1)) {
                // 昨天
                timeStr = context.getResources().getString(R.string.im_uikit_yesterday) + "   "  + hm.format(timestamp);
            } else {
                timeStr = mh.format(timestamp)+ "   " + hm.format(timestamp);
            }

        } else {
            timeStr = yh.format(timestamp) + "   " + hm.format(timestamp);
        }
        //[E] fix bug 12039 by licong

        return timeStr;
    }

    /**
     * 时间转换
     * @param timestamp
     * @return
     */
    public static String chatListDisplayTime(Context context, long timestamp)  {

        //今天  时间
        //昨天  昨天
        //当年  月日
        //其他  年月日
        String timeStr;
        //modify by zya 20161201
        SimpleDateFormat yh = new SimpleDateFormat(ActomaController.getAppConfigContext().getString(R.string.im_uikit_year_month_day));
        SimpleDateFormat mh = new SimpleDateFormat(ActomaController.getAppConfigContext().getString(R.string.im_uikit_month_day));

        /*SimpleDateFormat yh = new SimpleDateFormat("y" + ActomaController.getApp().getString(R.string.year) + "M" +ActomaController.getApp().getString(R.string.month) + "d" + ActomaController.getApp().getString(R.string.day));
        SimpleDateFormat mh = new SimpleDateFormat("M" + ActomaController.getApp().getString(R.string.month) + "d" + ActomaController.getApp().getString(R.string.day));*/
        //end by zya
        SimpleDateFormat hm = new SimpleDateFormat("HH:mm");
        long currentSeconds = System.currentTimeMillis();//系统当前时间
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentSeconds);

        //[S] fix bug 12039 by licong
        //系统当前年份、当前是哪一天
        int currentYear = cal.get(Calendar.YEAR);
        int currentMonth = cal.get(Calendar.MONTH);
        int currentDay  = cal.get(Calendar.DAY_OF_MONTH);

        //参数的年份，哪一天
        cal.setTimeInMillis(timestamp);
        int lastYear = cal.get(Calendar.YEAR);
        int lastMonth = cal.get(Calendar.MONTH);
        int lastDay  = cal.get(Calendar.DAY_OF_MONTH);

        if (currentYear == lastYear) {
            if (currentMonth == lastMonth && currentDay == lastDay) {
                // 今天
                timeStr =  hm.format(timestamp);
            } else if (currentMonth == lastMonth && ((currentDay-lastDay) == 1)) {
                // 昨天
                timeStr = context.getResources().getString(R.string.im_uikit_yesterday);
            } else {
                timeStr = mh.format(timestamp);
            }

        } else {
            timeStr = yh.format(timestamp);
        }

        //[E] fix bug 12039 by licong

        return timeStr;
    }

    /**
     * 文件相关时间进行转化
     *
     * @param timestamp
     * @return
     */
    public static String convertFileModifyDate(long timestamp) {
        if (timestamp == 0) {
            return "";
        }
        return getFormat(YMDHM).format(timestamp);
    }

    public static String displayShowTime(Context context, long timestamp)  {
        SimpleDateFormat yh = getFormat(context.getString(R.string.im_uikit_file_show_time));
        SimpleDateFormat hm = getFormat("HH:mm");
        return yh.format(timestamp)+ "   " + hm.format(timestamp);
    }

    //fix bug 11933 by zya ,20170514
    public static boolean isOverdue(long time) {
        long currTime = obtainCurrentTime();
        long result = currTime - time;
        if(result < 0){
            return true;
        } else {
            return result > ConstDef.TOTAL_TIME ;
        }
    }

    public static void setServerTime(String time){
        serverTime = time;
    }

    public static long obtainCurrentTime(){
        long mServerTime ;
        try{
            mServerTime = Long.parseLong(serverTime);
        } catch (Exception e){
            mServerTime = 0;
        }

        if(mServerTime != 0){
            return (SystemClock.elapsedRealtimeNanos() + mServerTime) / ConstDef.CHANGE_VALUE;
        } else {
            return System.currentTimeMillis();
        }
    }

    public static String stringOfOverdue(Context context, long time){
        SimpleDateFormat yh = getFormat(context.getString(R.string.im_uikit_file_show_time));
        if(!isOverdue(time)){
            long overdueTime = time + ConstDef.TOTAL_TIME;
            return yh.format(overdueTime);
        }
        return "";
    }

    public static String getCategoryIdWithTime(long time){
        SimpleDateFormat format = getFormat("yyyyMM");
        return format.format(time);
    }
}
