package com.xdja.im.lib.historyfile.view;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.lib.file.widget.ViewPagerIndicator;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.lib.filemanage.view.ImpActivitySuperView;
import com.xdja.im.lib.historyfile.command.IHistoryFileActivityPresenterCommand;
import com.xdja.im.lib.historyfile.util.HistoryModeUtils;
import com.xdja.im.lib.historyfile.vu.IHistoryFileActivityPresenterVu;
import com.xdja.im.uikit.R;


public class ViewHistoryFileActivityPresenter extends ImpActivitySuperView<IHistoryFileActivityPresenterCommand>
        implements IHistoryFileActivityPresenterVu, View.OnClickListener {

    private Toolbar toolbar;
    private ViewPager viewPager;
    private ViewPagerIndicator vpIndicator;
    private TextView mSelectCancel;
    private TextView mSelectTitle;
//    private TextView mBtnSelectAll;
    private TextView mSelectFileSize;
    private TextView mOperateAction;

    private RelativeLayout mToolbarLayout;
    private LinearLayout mOperationLayout;
    private RelativeLayout mOperateActionLayout;
    private LinearLayout mDownloadLayout, mTransmitLayout, mDeleteLayout;

    private int style = 0;
    private int mCurrentOperate;

    private SharedPreferences sharedPreferences;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_activity_history_all_files;
    }

    @Override
    protected int getToolbarType() {
        return ToolbarDef.NAVIGATE_BACK;
    }

    @Override
    public int getToolbarTitle() {
        return R.string.im_uikit_chat_file_history_list;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = getView();
        style = UniversalUtil.getThemeStyle(getContext());
        if (view != null) {
            toolbar = (Toolbar) view.findViewById(R.id.toolbar);
            mSelectCancel = (TextView) view.findViewById(R.id.select_cancel_action);
            mSelectTitle = (TextView) view.findViewById(R.id.history_file_selected_title);
            viewPager = (ViewPager) view.findViewById(R.id.history_file_vp);
            vpIndicator = (ViewPagerIndicator) view.findViewById(R.id.history_file_indicator);
//            mBtnSelectAll = (TextView) view.findViewById(R.id.select_all);

            mToolbarLayout = (RelativeLayout) view.findViewById(R.id.toolbar_layout);
            mOperationLayout = (LinearLayout) view.findViewById(R.id.file_operation_layout);
            mDownloadLayout = (LinearLayout) view.findViewById(R.id.btn_history_file_download_layout);
            mTransmitLayout = (LinearLayout) view.findViewById(R.id.btn_history_file_resend_layout);
            mDeleteLayout = (LinearLayout) view.findViewById(R.id.btn_history_file_remove_layout);

            mOperateActionLayout = (RelativeLayout) view.findViewById(R.id.operate_action_layout);
            mSelectFileSize = (TextView) view.findViewById(R.id.operate_file_size);
            mOperateAction = (TextView) view.findViewById(R.id.operate_action);
        }
    }

    @Override
    public void init(LayoutInflater inflater, ViewGroup container) {
        super.init(inflater, container);
        addListeners();
       // mToolbarLayout.setBackgroundResource(style == 0 ? R.drawable.im_uikit_af_abs_bg_s : R.drawable.im_uikit_af_abs_bg_s_light);
        mSelectCancel.setTextColor(style == 0 ? Color.parseColor("#AE9153") : Color.parseColor("#00BD71"));
//        mBtnSelectAll.setTextColor(style == 0 ? Color.parseColor("#AE9153") : Color.parseColor("#00BD71"));
        mSelectTitle.setTextColor(style == 0 ? Color.parseColor("#CCB481") : Color.parseColor("#F3000000"));

        sharedPreferences = getActivity().getSharedPreferences(ConstDef.PAGE_TAB_POSITION_RECORD, Context.MODE_PRIVATE);

    }

    private void addListeners(){
        mSelectCancel.setOnClickListener(this);
//        mBtnSelectAll.setOnClickListener(this);
        mDownloadLayout.setOnClickListener(this);
        mTransmitLayout.setOnClickListener(this);
        mDeleteLayout.setOnClickListener(this);
        mOperateAction.setOnClickListener(this);
    }

    public void setFragmentAdapter(FragmentPagerAdapter adapter) {
        viewPager.setOffscreenPageLimit(adapter.getCount());
        viewPager.setAdapter(adapter);
        viewPager.setCurrentItem(sharedPreferences.getInt(ConstDef.HISTORY_FILE_PAGE_POSITION, 0));
        vpIndicator.setViewPager(viewPager);
    }

    @Override
    public void onDestroy() {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(ConstDef.HISTORY_FILE_PAGE_POSITION, viewPager.getCurrentItem());
        editor.apply();
        super.onDestroy();
    }

    @Override
    public void showEmpty(boolean isShowEmpty) {

    }

    @Override
    public void refreshSelectHint(int num) {
        if (num == 0) {
            HistoryModeUtils.getInstance().clearCache();
        }
        if(mCurrentOperate != 0) {
            String title = getStringRes(R.string.im_uikit_history_file_select_hint);
            long size = HistoryModeUtils.getInstance().getSelectRawFileSize();
            mSelectFileSize.setText(String.format(title, FileSizeUtils.FormetFileSize(size)));

            if (mCurrentOperate == ConstDef.FILE_OPERATE_DOWNLOAD) {
                mOperateAction.setText(getStringRes(R.string.im_uikit_chat_file_history_list_download) + "(" + num + ")");
            } else if (mCurrentOperate == ConstDef.FILE_OPERATE_TRANSMIT) {
                mOperateAction.setText(getStringRes(R.string.im_uikit_chat_file_history_list_resend) + "(" + num + ")");
            } else if (mCurrentOperate == ConstDef.FILE_OPERATE_DELETE) {
                mOperateAction.setText(getStringRes(R.string.im_uikit_chat_file_history_list_remove) + "(" + num + ")");
            }
        }
    }

    @Override
    public void refreshUI() {
        if (mCurrentOperate != 0) {
            toolbar.setVisibility(View.INVISIBLE);
            mSelectCancel.setVisibility(View.VISIBLE);
            mSelectTitle.setVisibility(View.VISIBLE);
            mOperationLayout.setVisibility(View.GONE);
            mOperateActionLayout.setVisibility(View.VISIBLE);
        } else {
            mSelectCancel.setVisibility(View.GONE);
            mSelectTitle.setVisibility(View.GONE);
            toolbar.setVisibility(View.VISIBLE);
            toolbar.setTitle(R.string.im_uikit_chat_file_history_list);
            mOperationLayout.setVisibility(View.VISIBLE);
            mOperateActionLayout.setVisibility(View.GONE);
        }
        refreshSelectHint(0);
        getCommand().updateMode(mCurrentOperate);
    }

    @Override
    public void setOperateAction(int operateAction) {
        mCurrentOperate = operateAction;
    }

    @Override
    public void onClick(View v) {
        if (getCommand().isRefreshing()) {
            return;
        }
        if (v.getId() == R.id.select_cancel_action) {
            mCurrentOperate = 0;
            refreshUI();
            getCommand().obtainDataMap();
        } else if(v.getId() == R.id.btn_history_file_download_layout) {
            mCurrentOperate = ConstDef.FILE_OPERATE_DOWNLOAD;
            refreshUI();
        } else if(v.getId() == R.id.btn_history_file_resend_layout) {
            mCurrentOperate = ConstDef.FILE_OPERATE_TRANSMIT;
            refreshUI();
        } else if(v.getId() == R.id.btn_history_file_remove_layout) {
            mCurrentOperate = ConstDef.FILE_OPERATE_DELETE;
            refreshUI();
        } else if(v.getId() == R.id.operate_action) {
            if (mCurrentOperate == ConstDef.FILE_OPERATE_DOWNLOAD) {
                getCommand().downloadFiles();
            } else if(mCurrentOperate == ConstDef.FILE_OPERATE_TRANSMIT) {
                getCommand().transmitFiles();
            } else if(mCurrentOperate == ConstDef.FILE_OPERATE_DELETE) {
                getCommand().removeFiles();
            }
        } else if (v.getId() == R.id.select_all) {
//            if (TextUtils.equals(mBtnSelectAll.getText(), getStringRes(R.string.file_select_all))) {
//                mBtnSelectAll.setText(getStringRes(R.string.file_unselect_all));
//                getCommand().selectAll(true);
//            } else {
//                mBtnSelectAll.setText(getStringRes(R.string.file_select_all));
//                getCommand().selectAll(false);
//            }
        }
    }
}
