package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.view.ShowTextView;

/**
 * @Package: com.xdja.im.uikit.ui
 * @Author: xdjaxa
 * @Creation: 2017-04-20 15:03
 * @Version V1.0
 * @Description: 通知消息类型
 */
public class ViewNotifyItem extends BaseChatItem {

    /**
     * 通知消息
     */
    private ShowTextView mNotifyTv;
    private LinearLayout tv_notify_layout;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_notify;
    }

    @Override
    protected void injectView() {
        super.injectView();
        tv_notify_layout = (LinearLayout) findViewById(R.id.tv_notify_layout);
        mNotifyTv = (ShowTextView) findViewById(R.id.tv_notify);
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);

        tv_notify_layout.setVisibility(View.VISIBLE);
        mNotifyTv.setText(dataSource.getContent());
    }
}
