package com.xdja.im.common.cache.interf;

import android.support.annotation.Nullable;

import com.xdja.im.common.cache.entity.DeviceEntity;
import com.xdja.im.common.cache.entity.ServerEntity;

import java.util.Map;

/**
 * @Package:com.xdja.im.common.cache.interf
 * @Author:Lei
 * @Creation:2017-04-11 22:09
 * @Version 1.0
 * @Description: 配置信息缓存
 */
public interface ConfigCache {

    /**
     * 获取配置信息对象
     *
     * @return 配置信息对象
     */
    @Nullable
    Map<String, String> get();

    /**
     * 获取设备类型
     *
     * @return
     */
    DeviceEntity getDevice();

    /**
     * 获取服务器配置信息
     *
     * @return
     */
    ServerEntity getServer();
}
