package com.xdja.im.core.model.event;

import com.xdja.im.core.model.message.MeetInfo;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;

import java.util.List;

/**
 * @Package: com.xdja.im.core.model.event
 * @Author: xdjaxa
 * @Creation: 2017-05-07 11:10
 * @Version V1.0
 * @Description:消息列表相关事件
 */
public class IMProxyMessageEvent {

    /**
     * 消息相关的事件定义
     */
    public static class MessageEvent {
        /**
         * 聊天对象的账号
         */
        private String msgAccount;
        /**
         * 消息对象
         */
        private TalkMessageBean talkMessageBean;

        public String getMsgAccount() {
            return msgAccount;
        }

        public void setMsgAccount(String msgAccount) {
            this.msgAccount = msgAccount;
        }

        public TalkMessageBean getTalkMessageBean() {
            return talkMessageBean;
        }

        public void setTalkMessageBean(TalkMessageBean talkMessageBean) {
            this.talkMessageBean = talkMessageBean;
        }
    }

    /**
     * 创建新消息事件
     */
    public static class ReceiveNewMessageEvent extends MessageEvent {

        private List<TalkMessageBean> talkMessageList;

        public List<TalkMessageBean> getTalkMessageList() {
            return talkMessageList;
        }

        public void setTalkMessageList(List<TalkMessageBean> talkMessageBeansList) {
            this.talkMessageList = talkMessageBeansList;
        }
    }

    /**
     * 删除消息事件
     */
    public static class DeleteMessageEvent extends MessageEvent {
    }

    /**
     * 刷新单条消息事件
     */
    public static class RefreshMessageEvent extends MessageEvent {
    }

    /**
     * 清空会话事件
     */
    public static class DeleteAllMessageEvent extends MessageEvent {
    }

    /**
     * 刷新消息列表事件
     */
    public static class RefreshMessageListEvent {

        private boolean isNeedClearInput;

        public boolean isNeedClearInput() {
            return isNeedClearInput;
        }

        public void setNeedClearInput(boolean needClearInput) {
            isNeedClearInput = needClearInput;
        }
    }

    /**
     * 刷新消息列表事件
     */
    public static class RecallMessageEvent extends MessageEvent {
    }

    /**
     * 消息通知事件
     */
    public static class NewMsgComeEvent extends MessageEvent {

        private TalkSessionBean listBean;

        private int talkType;
        private List<TalkMessageBean> beans;

        public List<TalkMessageBean> getBeans() {
            return beans;
        }

        public void setBeans(List<TalkMessageBean> beans) {
            this.beans = beans;
        }

        public int getTalkType() {

            return talkType;
        }

        public void setTalkType(int talkType) {
            this.talkType = talkType;
        }

        public TalkSessionBean getListBean() {
            return listBean;
        }

        public void setListBean(TalkSessionBean listBean) {
            this.listBean = listBean;
        }
    }

    //add by zya
    public static class HistoryRefreshSelectHintEvent extends MessageEvent {}



    public static class ChatMeetRefreshStateHintEvent {

        private MeetInfo meetInfo;

        public MeetInfo getMeetInfo() {
            return meetInfo;
        }

        public void setMeetInfo(MeetInfo meetInfo) {
            this.meetInfo = meetInfo;
        }
    }

}
