package com.xdja.im.lib.historyfile.ui;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.squareup.otto.Subscribe;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.event.IMProxyEvent;
import com.xdja.im.core.model.event.IMProxyFileEvent;
import com.xdja.im.core.model.event.IMProxyMessageEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.core.repository.interf.ProxyRepository;
import com.xdja.im.lib.filemanage.model.GridItemBean;
import com.xdja.im.lib.filemanage.model.HistoryFileCategory;
import com.xdja.im.lib.filemanage.presenter.IMActivityPresenter;
import com.xdja.im.lib.filemanage.util.HistoryFileUtils;
import com.xdja.im.lib.filemanage.util.NetworkHelper;
import com.xdja.im.lib.filemanage.util.NetworkUtils;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.lib.historyfile.adapter.HistoryFragmentPageAdapter;
import com.xdja.im.lib.historyfile.command.IHistoryFileActivityPresenterCommand;
import com.xdja.im.lib.historyfile.fragment.HistoryFileListFragment;
import com.xdja.im.lib.historyfile.fragment.HistoryPhotoAndVideoFragment;
import com.xdja.im.lib.historyfile.util.HistoryModeUtils;
import com.xdja.im.lib.historyfile.view.ViewHistoryFileActivityPresenter;
import com.xdja.im.lib.historyfile.vu.IHistoryFileActivityPresenterVu;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.IntentParam;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.dialog.CustomDialog;
import com.xdja.im.uikit.utils.audio.AudioPlayerManagerProxy;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.inject.Inject;

import dagger.Lazy;
import rx.Subscriber;

import static android.R.attr.id;

public class HistoryFileActivityPresenter extends IMActivityPresenter<IHistoryFileActivityPresenterCommand, IHistoryFileActivityPresenterVu>
        implements IHistoryFileActivityPresenterCommand {

    private int[] historyTitleRes = {R.string.im_uikit_video_image,
            R.string.im_uikit_document,
            R.string.im_uikit_other};

    private String flag;

    private String talkId;

    private int talkType;

    private String[] titles;
    private List<Fragment> fragments;

    private HistoryFragmentPageAdapter mAdapter;

    private HistoryPhotoAndVideoFragment historyPhotoAndVideoFragment;

    private HistoryFileListFragment docFileListFragment;

    private HistoryFileListFragment otherFileListFragment;

    private List<GridItemBean> photoAndVideoGridDatas = new ArrayList<>();

    private Map<HistoryFileCategory, List<TalkMessageBean>> docDatas = new LinkedHashMap<>();

    private Map<HistoryFileCategory, List<TalkMessageBean>> otherDatas = new LinkedHashMap<>();

    BusProvider busProvider;

    @Inject
    Lazy<ProxyRepository> proxyRepository;

    private AlertDialog operateProgressDialog;
    private List<FileInfo> downloadingFiles = new ArrayList<>();
    private boolean refreshing;

    @Override
    public boolean isRefreshing() {
        return refreshing;
    }

    @NonNull
    @Override
    protected Class<? extends IHistoryFileActivityPresenterVu> getVuClass() {
        return ViewHistoryFileActivityPresenter.class;
    }

    @NonNull
    @Override
    protected IHistoryFileActivityPresenterCommand getCommand() {
        return this;
    }

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        if (null == userComponent) {
            LogUtil.e("HistoryFileActivityPresenter", "useCaseComponent is null");
            return;
        }
        //初始化注入
        userComponent.inject(this);
        busProvider = BusProvider.getInstance();
        busProvider.register(this);

        Intent intent = getIntent();
        if (intent != null) {
            Bundle bundle = intent.getExtras();
            initTitleAndFragments(bundle);
            flag = intent.getStringExtra(ConstDef.TAG_TALKFLAG);
            talkId = intent.getStringExtra(ConstDef.TAG_TALKERID);
            talkType = intent.getIntExtra(ConstDef.CHAT_TYPE, 1);
            if (TextUtils.isEmpty(flag)) {
                finish();
                return;
            }
            reSetTitle();
        }
    }

    private void reSetTitle() {
        setTitle(R.string.im_uikit_chat_file_history_list);
    }

    @Subscribe
    public void receiveEvent(IMProxyFileEvent.HistoryFileEvent historyFileEvent) {
        obtainDataMap();
    }

    @Override
    public void obtainDataMap() {
        if (refreshing) {
            return;
        }
        refreshing = true;

        ImUiKit.getInstance()
                .getComponent()
                .proxyRepository().getAllHistoryFileInfoWithTalkId(flag, ConstDef.FILE_ALL)
                .subscribe(new Subscriber<Map<HistoryFileCategory, List<TalkMessageBean>>>() {
                    @Override
                    public void onCompleted() {
                    }

                    @Override
                    public void onError(Throwable e) {
                    }

                    @Override
                    public void onNext(Map<HistoryFileCategory, List<TalkMessageBean>> dataMaps) {
                        photoAndVideoGridDatas.clear();
                        docDatas.clear();
                        otherDatas.clear();
                        for (Map.Entry<HistoryFileCategory, List<TalkMessageBean>> entry : dataMaps.entrySet()) {
                            List<TalkMessageBean> talkMsgs = entry.getValue();
                            List<TalkMessageBean> filterMsgs1 = new LinkedList<TalkMessageBean>();
                            List<TalkMessageBean> filterMsgs2 = new LinkedList<TalkMessageBean>();
                            List<TalkMessageBean> filterMsgs3 = new LinkedList<TalkMessageBean>();
                            for (TalkMessageBean bean : talkMsgs) {
                                FileInfo fileInfo = bean.getFileInfo();
                                if (bean.getMessageState() == ConstDef.STATE_SEND_FAILED ||
                                        bean.getMessageState() == ConstDef.STATE_SENDING) {
                                    continue;
                                }
                                int fileType = FileUtils.getTypeWithSuffix(fileInfo.getFilePath());
                                if (fileType == ConstDef.FILE_NO_SUFFIX) {
                                    fileType = fileInfo.getFileType();
                                } else if (fileType == ConstDef.FILE_TYPE_NORMAL){
                                    fileType = fileInfo.getFileType();
                                }
                                bean.getFileInfo().setFileType(fileType);
                                if (fileType == ConstDef.FILE_TYPE_PHOTO) {
                                    filterMsgs1.add(bean);
                                } else if (fileType == ConstDef.FILE_TYPE_VIDEO) {
                                    filterMsgs1.add(bean);
                                } else if (fileType == ConstDef.FILE_TYPE_TXT || fileType == ConstDef.FILE_TYPE_PDF ||
                                        fileType == ConstDef.FILE_TYPE_WORD || fileType == ConstDef.FILE_TYPE_PPT ||
                                        fileType == ConstDef.FILE_TYPE_EXCEL) {
                                    filterMsgs2.add(bean);
                                } else {
                                    filterMsgs3.add(bean);
                                }
                            }

                            if (filterMsgs1.size() > 0) {
                                GridItemBean gridItemBean = new GridItemBean();
                                gridItemBean.setValue(entry.getKey());
                                gridItemBean.setChildList(filterMsgs1);
                                gridItemBean.setExpand(false);
                                photoAndVideoGridDatas.add(gridItemBean);
                            }
                            if (filterMsgs2.size() > 0) {
                                docDatas.put(entry.getKey(), filterMsgs2);
                            }
                            if (filterMsgs3.size() > 0) {
                                otherDatas.put(entry.getKey(), filterMsgs3);
                            }
                        }
                        historyPhotoAndVideoFragment.notifyDataChange();
                        docFileListFragment.notifyDataChange();
                        otherFileListFragment.notifyDataChange();
                        refreshing = false;
                    }
                });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();

        if (busProvider != null) {
            busProvider.unregister(this);
        }
    }

    private void initTitleAndFragments(Bundle bundle) {
        titles = changeTitle();
        docFileListFragment = new HistoryFileListFragment();
        otherFileListFragment = new HistoryFileListFragment();
        historyPhotoAndVideoFragment = new HistoryPhotoAndVideoFragment();

        historyPhotoAndVideoFragment.setDatas(photoAndVideoGridDatas);
        docFileListFragment.setDatas(docDatas);
        otherFileListFragment.setDatas(otherDatas);

        docFileListFragment.setTitle("doc");
        otherFileListFragment.setTitle("other");
        Bundle bundle1 = bundle;
        bundle1.putInt("tag", 0);
        Bundle bundle2 = bundle;
        bundle2.putInt("tag", 1);
        Bundle bundle3 = bundle;
        bundle3.putInt("tag", 2);
        historyPhotoAndVideoFragment.setArguments(bundle1);
        docFileListFragment.setArguments(bundle2);
        otherFileListFragment.setArguments(bundle3);

        fragments = new ArrayList<>();
        fragments.add(historyPhotoAndVideoFragment);
        fragments.add(docFileListFragment);
        fragments.add(otherFileListFragment);
        mAdapter = new HistoryFragmentPageAdapter(getSupportFragmentManager(), titles, fragments);
        getVu().setFragmentAdapter(mAdapter);
    }

    private String[] changeTitle() {
        String[] tempTitles = new String[historyTitleRes.length];
        for (int i = 0; i < historyTitleRes.length; i++) {
            tempTitles[i] = getString(historyTitleRes[i]);
        }
        return tempTitles;
    }

    @Override
    public void downloadFiles() {
        List<TalkMessageBean> downloadBeans = HistoryModeUtils.getInstance().getAllSelectFiles();//getCheckBean();
        if (downloadBeans.size() == 0) {
            //提示选择的文件不可为空
            new XToast(this).display(getString(R.string.im_uikit_history_select_file_none));
            return;
        }

        final List<FileInfo> downloadFiles = new ArrayList<>();
        for (TalkMessageBean bean : downloadBeans) {
            FileInfo fileInfo = bean.getFileInfo();
            if (fileInfo instanceof VideoFileInfo) {
                ((VideoFileInfo) fileInfo).setType(ConstDef.IS_RAW);
            } else if (fileInfo instanceof ImageFileInfo) {
                if (((ImageFileInfo) fileInfo).isOriginal()) {
                    ((ImageFileInfo) fileInfo).setType(ConstDef.IS_RAW);
                } else {
                    ((ImageFileInfo) fileInfo).setType(ConstDef.IS_HD);
                }
            }
            downloadFiles.add(fileInfo);
        }
        showDialogDownloadFile(downloadFiles);
    }

    public void showDialogDownloadFile(final List<FileInfo> downloadFiles) {
        if (NetworkHelper.getHelper().networkUseless()) {
            new XToast(this).display(R.string.im_uikit_network_disabled);
            return;
        }
        if (NetworkUtils.obtainCurrentNetworkState(this) == NetworkUtils.MOBILE_NETWORK) {
            //检测是否为2G/3G/4G网络
            final CustomDialog dialog = new CustomDialog(this, new CustomDialog.OnCloseListener() {
                @Override
                public void onClick(Dialog dialog, boolean confirm) {
                    if (confirm)
                        resumeOrDownloadFiles(downloadFiles);
                }
            });
            dialog.setDialogTitle(R.string.im_uikit_download_file_title)
                    .setDialogContent(R.string.im_uikit_download_file_net_type)
                    // 设置内容
                    .setPositiveButton(getString(R.string.im_uikit_download_file_btn_continue))
                    .setNegativeButton(getString(R.string.im_uikit_download_file_btn_cancel))
                    .show();
        } else {
            resumeOrDownloadFiles(downloadFiles);
        }
    }

    private void resumeOrDownloadFiles(final List<FileInfo> downloadFiles) {
        downloadingFiles.addAll(downloadFiles);
        showOperateProgressDialog(getString(R.string.im_uikit_file_downloading), false, true);
        getVu().setOperateAction(ConstDef.FILE_OPERATE_NONE);
        proxyRepository.get().downloadFile(downloadFiles, new Subscriber<Integer>() {
            @Override
            public void onCompleted() {
                LogUtil.d("downloadFile file finished.");
            }

            @Override
            public void onError(Throwable e) {
                LogUtil.d("ERROR : downloadFile file error.");
            }

            @Override
            public void onNext(Integer integer) {
                addDownloadPercentCache(downloadFiles);
                LogUtil.d("downloadFile file start.");
            }
        });
    }

    @Subscribe
    public void NetworkStateChange(IMProxyEvent.NetworkStateEvent event) {
        if (event.getState() != NetworkHelper.NET_OK && !downloadingFiles.isEmpty()) {
            dismissOperateProgressDialog();
            new XToast(this).display(R.string.im_uikit_network_change_pause_download);
            getVu().refreshUI();
            obtainDataMap();
        }
    }

    @Subscribe
    public void receiveFileFinishedEvent(final IMProxyFileEvent.ReceiveFileFinishedEvent event) {
        if (operateProgressDialog != null && operateProgressDialog.isShowing()) {
            Iterator iterator = downloadingFiles.iterator();
            while (iterator.hasNext()) {
                FileInfo fileInfo = (FileInfo) iterator.next();
                if (fileInfo.getTalkMessageId() == event.getAttachedMsgId()) {
                    iterator.remove();
                }
            }
            if (downloadingFiles.isEmpty()) {
                dismissOperateProgressDialog();
                getVu().refreshUI();
                obtainDataMap();
            }
        }
    }

    @Subscribe
    public void receiveFileFailedEvent(final IMProxyFileEvent.ReceiveFileFailedEvent event) {
        if (operateProgressDialog != null && operateProgressDialog.isShowing()) {
            Iterator iterator = downloadingFiles.iterator();
            while (iterator.hasNext()) {
                FileInfo fileInfo = (FileInfo) iterator.next();
                if (fileInfo.getTalkMessageId() == event.getAttachedMsgId()) {
                    iterator.remove();
                }
            }
            if (downloadingFiles.isEmpty()) {
                dismissOperateProgressDialog();
                getVu().refreshUI();
                obtainDataMap();
            }
        }
    }

    private void addDownloadPercentCache(List<FileInfo> downloadFiles) {
        for (FileInfo fInfo : downloadFiles) {
            userCache.putProgress(fInfo.getTalkMessageId(), 0);
            fInfo.setFileState(ConstDef.LOADING);
        }
    }

    @Override
    public void transmitFiles() {

        //获取已经选择的文件
        List<TalkMessageBean> transmitBeans = HistoryModeUtils.getInstance().getAllSelectFiles();//getCheckBean();

        if (transmitBeans.size() == 0) {
            new XToast(this).display(getString(R.string.im_uikit_history_select_file_none));
            return;
        }

        ArrayList<FileInfo> transmitFiles = new ArrayList<>();
        for (TalkMessageBean bean : transmitBeans) {
            FileInfo fileInfo = bean.getFileInfo();
            String rawFilePath = "";
            String filePath = "";
            if (fileInfo instanceof VideoFileInfo) {
                rawFilePath = ((VideoFileInfo) fileInfo).getRawFileInfo().getFilePath();
            } else if (fileInfo instanceof ImageFileInfo) {
                rawFilePath = ((ImageFileInfo) fileInfo).getRawFileInfo().getFilePath();
                filePath = fileInfo.getFilePath();
            } else {
                filePath = fileInfo.getFilePath();
            }
            if (HistoryFileUtils.isFileExist(rawFilePath) || HistoryFileUtils.isFileExist(filePath)) {
                transmitFiles.add(bean.getFileInfo());
            }
        }
        //文件判断
        if (transmitFiles.size() == 0) {
            //原文件都不存在不可转发,请先下载
            new XToast(this).display(getString(R.string.im_uikit_history_transmit_all_noexist));
            return;
        } else if (transmitFiles.size() > 0 && transmitFiles.size() < transmitBeans.size()) {
            //存在未下载的文件，只可以部分转发
            new XToast(this).display(getString(R.string.im_uikit_history_transmit_part_noexist));
        }
        //转发文件 此处做回掉处理或otto
        //IntentParam.startChatListActivity(this,talkId,talkType,transmitFiles);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        if (requestCode == IntentParam.REQUEST_CODE_FORWARD) {
            getVu().setOperateAction(ConstDef.FILE_OPERATE_NONE);
            getVu().refreshUI();
            obtainDataMap();
        }
    }

    @Override
    public void removeFiles() {
        List<TalkMessageBean> deleteBeans = HistoryModeUtils.getInstance().getAllSelectFiles();//getCheckBean();

        if (deleteBeans.size() == 0) {
            new XToast(this).display(getString(R.string.im_uikit_history_select_file_none));
            return;
        }
        List<Long> deleteIds = new ArrayList<>();
        for (TalkMessageBean bean : deleteBeans) {
            deleteIds.add(bean.getId());
        }
        showRemoveDialog(deleteIds, deleteBeans);
    }

    private void showOperateProgressDialog(String msg, boolean isOutsideTouchCancelable, boolean isBackCancelable) {
        operateProgressDialog = new AlertDialog.Builder(this).create();
        Window dialogWindow = operateProgressDialog.getWindow();
        WindowManager.LayoutParams lp = dialogWindow.getAttributes();
        lp.alpha = 0.5f;
        dialogWindow.setAttributes(lp);
        dialogWindow.setDimAmount(0f);
        View view = getLayoutInflater().inflate(R.layout.im_uikit_operate_progress_dialog, null);
        ProgressBar progressBar = (ProgressBar) view.findViewById(R.id.progress);
        int style = UniversalUtil.getThemeStyle(this);
        progressBar.setIndeterminateDrawable(getResources().getDrawable(style == 0 ?
                R.drawable.im_uikit_circle_progressbar : R.drawable.im_uikit_circle_progressbar_light));
        TextView messageView = (TextView) view.findViewById(R.id.dialog_message);

        messageView.setText(msg);
        operateProgressDialog.setView(view);
        operateProgressDialog.setCanceledOnTouchOutside(isOutsideTouchCancelable);
        operateProgressDialog.setCancelable(isBackCancelable);
        operateProgressDialog.setOnCancelListener(new DialogInterface.OnCancelListener() {
            @Override
            public void onCancel(DialogInterface dialog) {
                getVu().refreshUI();
                obtainDataMap();
            }
        });
        operateProgressDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
            @Override
            public void onDismiss(DialogInterface dialog) {
                if (!downloadingFiles.isEmpty()) {
                    pauseDownloadFile();
                }
                downloadingFiles.clear();
            }
        });

        if (!operateProgressDialog.isShowing()) {
            operateProgressDialog.show();
        }
    }


    private void pauseDownloadFile() {
        for (final FileInfo fileInfo : downloadingFiles) {
            fileInfo.setFileState(ConstDef.PAUSE);
            proxyRepository.get().pauseFileReceiving(fileInfo, new Subscriber<Integer>() {
                @Override
                public void onCompleted() {
                    LogUtil.d("Pause downloadFile file finished.");
                }

                @Override
                public void onError(Throwable e) {
                    LogUtil.d("ERROR : pause downloadFile file error.");
                }

                @Override
                public void onNext(Integer integer) {
                    if (integer == 0) {
                        LogUtil.d("", "-->暂停下载文件 fileInfo =" + fileInfo);
                    }
                }
            });
        }
    }

    private void dismissOperateProgressDialog() {
        if (operateProgressDialog != null && operateProgressDialog.isShowing()) {
            operateProgressDialog.dismiss();
            operateProgressDialog = null;
        }
    }

    /**
     * 删除确认框
     *
     * @param ids
     */
    public void showRemoveDialog(final List<Long> ids, final List<TalkMessageBean> deleteBeans) {

        new CustomDialog(this, new CustomDialog.OnCloseListener() {
            @Override
            public void onClick(Dialog dialog, boolean confirm) {
                if (confirm) {
                    deleteMsg(ids, deleteBeans);
                }
            }
        })
                .setDialogTitle(getString(R.string.im_uikit_history_file_delete_hint))
                .setDialogContent(getString(R.string.im_uikit_history_file_delete_message))
                .setNegativeButton(getString(R.string.im_uikit_download_file_btn_cancel))
                .setPositiveButton(getString(R.string.im_uikit_history_file_delete_confirm))
                .show();
    }

    /**
     * 多选删除和长按删除区别更新
     *
     * @param deleteBeans
     */
    private void updateUIAfterDeleteFiles(List<TalkMessageBean> deleteBeans) {
        HistoryModeUtils.getInstance().clearCache();

        for (Fragment fragment : fragments) {
            if (fragment instanceof HistoryPhotoAndVideoFragment) {
                ((HistoryPhotoAndVideoFragment) fragment).updateUIAfterDeleteFiles(deleteBeans);
            }
            if (fragment instanceof HistoryFileListFragment) {
                ((HistoryFileListFragment) fragment).updateUIAfterDeleteFiles(deleteBeans);
            }
        }

        if (deleteBeans != null && deleteBeans.size() > 0) {
            if (deleteBeans.size() > 1) {
                for (int i = 0; i < deleteBeans.size(); i++) {
                    IMProxyMessageEvent.DeleteMessageEvent event = new IMProxyMessageEvent.DeleteMessageEvent();
                    event.setTalkMessageBean(deleteBeans.get(i));
                    event.setMsgAccount(deleteBeans.get(i).getFrom());
                    busProvider.post(event);
                }
            } else {
                IMProxyMessageEvent.DeleteMessageEvent event = new IMProxyMessageEvent.DeleteMessageEvent();
                event.setTalkMessageBean(deleteBeans.get(0));
                event.setMsgAccount(deleteBeans.get(0).getFrom());
                busProvider.post(event);
            }
        }
    }


    private void deleteMsg(final List<Long> ids, final List<TalkMessageBean> deleteBeans) {
        showOperateProgressDialog(getString(R.string.im_uikit_is_deleting), false, true);
        proxyRepository.get().deleteMessages(ids, new Subscriber<Integer>() {
            @Override
            public void onCompleted() {
                LogUtil.d("Delete message successfully. " + id);
            }

            @Override
            public void onError(Throwable e) {
                dismissOperateProgressDialog();
                getVu().setOperateAction(ConstDef.FILE_OPERATE_NONE);
                getVu().refreshUI();
                LogUtil.d("", "消息删除失败");
            }

            @Override
            public void onNext(Integer integer) {
                if (integer == 0) {
                    LogUtil.d("", "消息删除成功");
                    updateUIAfterDeleteFiles(deleteBeans);
                    dismissOperateProgressDialog();
                    getVu().setOperateAction(ConstDef.FILE_OPERATE_NONE);
                    getVu().refreshUI();
                }
            }
        });
    }


    @Override
    public void updateMode(int operateAction) {
        for (Fragment fragment : fragments) {
            if (fragment instanceof HistoryFileListFragment) {
                ((HistoryFileListFragment) fragment).updateMode(operateAction);
            } else if (fragment instanceof HistoryPhotoAndVideoFragment) {
                ((HistoryPhotoAndVideoFragment) fragment).updateMode(operateAction);
            }
        }
    }

    @Subscribe
    public void historyRefreshSelectHintEvent(IMProxyMessageEvent.HistoryRefreshSelectHintEvent event) {
        List<TalkMessageBean> checkLists = HistoryModeUtils.getInstance().getAllSelectFiles();
        getVu().refreshSelectHint(checkLists != null ? checkLists.size() : 0);
    }


    /**
     * 接收到撤回事件
     * 界面收到撤回事件后进行刷新
     *
     * @param event
     */
    @Subscribe
    public void onRefreshRecallMessage(final IMProxyEvent.RecallMessageEvent event) {
        if (event == null || event.getTalkMessageBean() == null) {
            return;
        }
        TalkMessageBean bean = event.getTalkMessageBean();
        if (bean.getFileInfo() != null) {
            List<Long> ids = new ArrayList<>();
            ids.add(bean.getId());
            List<TalkMessageBean> deleteBeans = new ArrayList<>();
            deleteBeans.add(bean);
            deleteMsg(ids, deleteBeans);
        }

    }

}
