package com.xdja.im.uikit;

import com.xdja.im.core.model.param.RemindAction;
import com.xdja.im.core.model.param.SettingParam;

/**
 * @Package: com.xdja.im.uikit
 * @Author: xdjaxa
 * @Creation: 2017-08-08 17:42
 * @Version V1.0
 * @Description: IMUIKit设置相关接口信息，目前主要包括：听筒模式、新消息提醒、勿扰模式
 */
public interface ISetting {

    /**
     * 获取系统设置参数信息
     *
     * @return 设置信息参数 {@link SettingParam}
     */
    SettingParam getSettingParam();

    /**
     * 更改提醒方式
     *
     * @param action {@link com.xdja.im.core.model.param.RemindAction.Action}
     */
    void setRemindType(@RemindAction.Action int action);

    /**
     * 设置听筒模式
     *
     * @param isOpen {@code true}：开启；{@code false}：关闭
     */
    void setReceiveMode(boolean isOpen);

    /**
     * 设置勿扰模式
     *
     * @param isOpen {@code true}：开启；{@code false}：关闭
     */
    void setDisturbMode(boolean isOpen);

    /**
     * 设置勿扰开始时间
     *
     * @param disturbStart 勿扰开始时间
     */
    void setDisturbStart(long disturbStart);

    /**
     * 设置勿扰结束时间
     *
     * @param disturbEnd 勿扰结束时间
     */
    void setDisturbEnd(long disturbEnd);
}

