package com.xdja.im.uikit.ui.presenter;

import android.widget.ImageView;

import com.xdja.im.base.frame.Presenter;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;

import java.io.File;

/**
 * @Package: com.xdja.im.uikit.ui.presenter
 * @Author: xdjaxa
 * @Creation: 2017-05-15 11:10
 * @Version V1.0
 * @Description:
 */
public interface FilePreviewAdapterPresenter extends Presenter {

    /**
     * 加载图片
     *
     * @param imageView 图片显示控件
     * @param filePath  图片路径
     * @param width     宽度
     * @param height    高度
     */
    void loadImage(ImageView imageView, String filePath, ImageView.ScaleType scaleType, int width, int height);

    /**
     * 下载文件
     *
     * @param fileInfo
     */
    void download(FileInfo fileInfo);

    /**
     * 保存文件至本地
     *
     * @param srsFile  源文件
     * @param savePath 保存文件路径
     * @param fileName 保存文件名称
     */
    void saveFile(File srsFile, String savePath, String fileName);

    /**
     * 删除某条消息
     *
     * @param bean
     */
    void deleteMsg(TalkMessageBean bean);
}
