package com.xdja.im.uikit.ui.view;

import android.graphics.Color;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;

import com.xdja.im.base.frame.view.AdapterBaseView;
import com.xdja.im.base.frame.view.AdapterSuperBaseView;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.utils.DataCache;
import com.xdja.im.core.utils.ToolUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;
import com.xdja.im.uikit.constans.Constant;
import com.xdja.im.uikit.ui.dialog.BaseListDialog;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.TimeUtil;
import com.xdja.im.uikit.view.CircleImageView;

import java.util.ArrayList;
import java.util.List;

import rx.Subscriber;

/**
 * @Package: com.xdja.im.uikit.ui
 * @Author: xdjaxa
 * @Creation: 2017-04-20 14:38
 * @Version V1.0
 * @Description:聊天栏目基类
 */
public class BaseChatItem extends AdapterSuperBaseView<ChatListAdapterPresenter, TalkMessageBean>
        implements AdapterBaseView<ChatListAdapterPresenter, TalkMessageBean> {

    /**
     * 时间差
     */
    public static final long TIME_DIFFERENCE = 5 * 60 * 1000;
    /**
     * 头像
     */
    private CircleImageView mUserHeader;
    /**
     * 昵称
     */
    protected TextView mUserName;
    /**
     * 时间线
     */
    private TextView mTimeLineTv;
    /**
     * 长按弹框
     */
    protected BaseListDialog mPopDialog;
    /**
     * 弹框选项事件
     */
    protected List<ImOption> mImOptions = new ArrayList<>();

    @Override
    protected void injectView() {
        super.injectView();
        mUserHeader = (CircleImageView) findViewById(R.id.img_user_icon);
        mTimeLineTv = (TextView) findViewById(R.id.tv_timeLine);

        mPopDialog = new BaseListDialog(getContext()) {
            @Override
            public List<ImOption> getOptions() {
                return buildImOptions();
            }
        };
        mUserHeader.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
               /* if (dataSource.isMine()) {
                    return;
                }*/

                String account = dataSource.getFrom();
                if (TextUtils.isEmpty(account)) {
                    LogUtil.e("ERROR: User account is null.");
                    return;
                }
                LogUtil.d("Start open user setting.(" + account + ")");
                getPresenter().openUserInfo(account);
            }
        });

        mUserHeader.setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View v) {
                if (dataSource.isGroupMsg()) {
                    getPresenter().onLongClickAtUser(dataSource.getTo(),dataSource.getFrom());
                    return true;
                } else
                return false;
            }
        });

    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);

        //时间线计算
        if (position == 0) {
            setTimeLineVisible(dataSource.getShowTime());
        } else {
            TalkMessageBean lastMessage = getPresenter().getTalkMessage(curPosition - 1);
            if (lastMessage != null && dataSource.getShowTime() - lastMessage.getShowTime() > TIME_DIFFERENCE) {
                mTimeLineTv.setVisibility(View.VISIBLE);
                mTimeLineTv.setText(TimeUtil.convertChatTime(dataSource.getShowTime()));
            } else {
                mTimeLineTv.setVisibility(View.GONE);
            }
        }

        //通知类型消息
        if (dataSource.getMessageType() == ConstDef.MSG_TYPE_PRESENTATION) {
            return;
        }

        //加载用户信息
        try {
            loadUserData();
        } catch (Exception e) {
        }
    }

    private void setTimeLineVisible(long time) {
        mTimeLineTv.setVisibility(View.VISIBLE);
        mTimeLineTv.setText(TimeUtil.convertChatTime(time));
    }

    protected int getNormalTextColor() {
        return Color.BLACK;
    }

    protected int getLimitTextColor() {
        return Color.LTGRAY;
    }

    private List<ImOption> buildImOptions() {
        mImOptions.add(new ImOption(Constant.ITEM_CHAT_DELETE, getStringRes(R.string.im_uikit_chat_option_delete)));
        mImOptions.add(new ImOption(Constant.ITEM_CHAT_COPY, getStringRes(R.string.im_uikit_chat_option_copy)));
        mImOptions.add(new ImOption(Constant.ITEM_CHAT_RECALL, getStringRes(R.string.im_uikit_chat_option_recall)));
        mImOptions.add(new ImOption(Constant.ITEM_CHAT_RESEND, getStringRes(R.string.im_uikit_chat_option_resend)));
        return mImOptions;
    }

    protected void loadUserData() {
        //消息用户账号信息
        final String account = dataSource.getFrom();
        if (TextUtils.isEmpty(account)) {
            return;
        }
        String sessionFlag = ToolUtils.getSessionTag(account, ConstDef.CHAT_TYPE_P2P);

        //缓存hu获取
        AccountBean accountBean = (AccountBean) DataCache.getInstance().get(sessionFlag);
        if (accountBean != null) {
            mUserHeader.loadImage(accountBean.getAvatarUrl(), true,
                    R.mipmap.im_uikit_user_header_40dp);

            //群组显示群成员名称
            if (mUserName != null && dataSource.isGroupMsg() && !dataSource.isMine()) {
                mUserName.setText(accountBean.getDisplayName());
            }
            return;
        }

        getPresenter().getAccount(account, ConstDef.CHAT_TYPE_P2P, new Subscriber<AccountBean>() {
            @Override
            public void onCompleted() {

            }

            @Override
            public void onError(Throwable e) {
                LogUtil.w("ERROR: get account failed." + account);
            }

            @Override
            public void onNext(final AccountBean accountBean) {
                if (accountBean == null) {
                    return;
                }
                mUserHeader.loadImage(accountBean.getAvatarUrl(), true,
                        R.mipmap.im_uikit_user_header_40dp);

                //群组显示群成员名称
                if (mUserName != null && dataSource.isGroupMsg() && !dataSource.isMine()) {
                    mUserName.setText(accountBean.getDisplayName());
                }
            }
        });
    }
}
